#ifndef CLIPBOARD_H
#define CLIPBOARD_H

#include <QDialog>
#include <QListWidgetItem>

namespace Ui {
    class Clipboard;
}

class Clipboard : public QDialog
{
    Q_OBJECT

public:
    explicit Clipboard(QWidget *parent = 0, QString selected = "");
    ~Clipboard();
    QString clippath;

public slots:
    void orientationChanged();
    void loadClipboard();
    void deleteClipboard(bool refresh = true);
    void clearClipboard();
    void pasteFile();
    void cutFile();
    void checkSelected();

private:
    Ui::Clipboard *ui;

private slots:
    void on_listWidget_itemClicked(QListWidgetItem* item);
    void on_h_cut_pressed();
    void on_v_cut_pressed();
    void on_h_paste_pressed();
    void on_v_paste_pressed();
    void on_h_clear_pressed();
    void on_v_clear_pressed();
    void on_h_delete_pressed();
    void on_v_delete_pressed();

protected:
    virtual void keyPressEvent(QKeyEvent* k);
    virtual void keyReleaseEvent(QKeyEvent* k);

};

#endif // CLIPBOARD_H
