#include "QMaemo5InformationBox"
#include "toolsdialog.h"
#include "ui_toolsdialog.h"
#include <QSettings>
#include "sort.h"
#include "newfolder.h"
#include "newdoc.h"
#include "qmaemo5rotator.h"

ToolsDialog::ToolsDialog(QWidget *parent, QString selected) :
    QDialog(parent),
    ui(new Ui::ToolsDialog)
{
    ui->setupUi(this);
    file1 = selected;

    connect(QApplication::desktop(), SIGNAL(resized(int)), this, SLOT(orientationChanged()));

    setAttribute(Qt::WA_Maemo5AutoOrientation, true);
    QCoreApplication::processEvents();
    orientationChanged();

}

ToolsDialog::~ToolsDialog()
{
    delete ui;

}

void ToolsDialog::orientationChanged()
{
    QRect screenGeometry = QApplication::desktop()->screenGeometry();
    if (screenGeometry.width() < screenGeometry.height())
    {
        ui->widget_2->setVisible(false);
        ui->pushButton_3->setVisible(true);
        ui->pushButton_4->setVisible(true);
        ui->pushButton_9->setVisible(true);
        ui->pushButton->setVisible(true);
        //QCoreApplication::processEvents();
        //this->setMaximumHeight(300);
    }
    else
    {
        ui->widget_2->setVisible(true);
        ui->pushButton_3->setVisible(false);
        ui->pushButton_4->setVisible(false);
        ui->pushButton_9->setVisible(false);
        ui->pushButton->setVisible(false);
        //QCoreApplication::processEvents();
        //this->setMaximumHeight(150);
    }
    QCoreApplication::processEvents();
    if ( ui->widget_2->isVisible() ) this->setMaximumHeight(150);
    else this->setMaximumHeight(300);
    this->adjustSize();

}

void ToolsDialog::on_pushButton_clicked()
{
    QSettings settings("cepiperez","filemanager_bookmarks");
    QStringList list = settings.value("Bookmarks",QStringList()).toStringList();
    if ( list.indexOf(file1) == -1 ) list.append(file1);
    settings.setValue("Bookmarks", list);
    settings.sync();
    this->close();

}

void ToolsDialog::on_pushButton_2_clicked()
{
    QSettings settings("cepiperez","filemanager");
    settings.setValue("NeedToRefresh", "No");
    NewFolder* rd = new NewFolder( this, file1 );
    rd->exec(); this->close();
}

void ToolsDialog::on_pushButton_3_clicked()
{
    QSettings settings("cepiperez","filemanager");
    settings.setValue("NeedToRefresh", "No");
    Sort* sw = new Sort(this);
    sw->exec(); this->close();
}

void ToolsDialog::on_pushButton_4_clicked()
{
    QSettings settings("cepiperez","filemanager");
    settings.setValue("NeedToRefresh", "No");
    NewDoc* fw = new NewDoc(this,file1);
    fw->exec(); this->close();
}

void ToolsDialog::on_pushButton_6_clicked()
{
    on_pushButton_4_clicked();
}

void ToolsDialog::on_pushButton_5_clicked()
{
    on_pushButton_3_clicked();
}


void ToolsDialog::on_pushButton_7_clicked()
{
    QString sended = "#!/bin/sh\n";
    sended += "cd '" + file1 + "'\n";
    if ( QFileInfo("/home/user/.config/cepiperez/.rootenabled").exists() )
    {
        if ( QFileInfo("/usr/bin/rootsh").exists() )
            sended += "sudo gainroot";
        else
        {
            sended += "echo 'No root user enabled in x-term. You need to install rootsh.'\n";
            sended += "/bin/sh";
        }
    }
    else sended += "/bin/sh";

    QString sended2 = QString("echo \"%1\" > /home/user/filebox-terminal").arg(sended);
    QByteArray ba = sended2.toLatin1();
    const char *str1 = ba.data();
    system(str1);

    sended2 = "chmod +x /home/user/filebox-terminal";
    ba = sended2.toLatin1();
    str1 = ba.data();
    system(str1);

    sended2 = "osso-xterm \"/home/user/filebox-terminal\"&";
    ba = sended2.toLatin1();
    str1 = ba.data();
    system(str1);

    this->close();
}

void ToolsDialog::on_pushButton_8_clicked()
{
    QSettings settings("cepiperez","filemanager");
    QStringList temp = settings.value("ClipboardSelected", QStringList() ).toStringList();
    if ( temp.count() > 0 )
    {
        settings.setValue("FilesToPaste",temp);
        settings.sync();
    }
    else
    {
        QString msg = QString(tr("ERROR: Nothing selected to paste"));
        QMaemo5InformationBox::information(this, msg, QMaemo5InformationBox::DefaultTimeout);
    }
    this->close();
}

void ToolsDialog::on_pushButton_9_clicked()
{
    QSettings settings("cepiperez","filemanager");
    QStringList temp = settings.value("ClipboardSelected", QStringList() ).toStringList();
    if ( temp.count() > 0 )
    {
        settings.setValue("FilesToCut",temp);
        settings.sync();
    }
    else
    {
        QString msg = QString(tr("ERROR: Nothing selected to paste"));
        QMaemo5InformationBox::information(this, msg, QMaemo5InformationBox::DefaultTimeout);
    }
    this->close();
}

void ToolsDialog::on_pushButton_10_clicked()
{
    on_pushButton_9_clicked();
}

void ToolsDialog::on_pushButton_11_clicked()
{
    QSettings settings("cepiperez","filemanager");
    settings.setValue("AddSymlink","Yes");
    settings.sync();
    this->close();
}

void ToolsDialog::on_pushButton_12_clicked()
{
    on_pushButton_clicked();
}
