
 #include <QtGui/qplaintextedit.h>
 #include <QtGui/qtextedit.h>
 #include <QtGui/qabstractkineticscroller.h>

 #ifndef TEXTEDITAUTORESIZER_H
 #define TEXTEDITAUTORESIZER_H

 class TextEditAutoResizer : public QObject
 {
     Q_OBJECT
 public:
     TextEditAutoResizer(QWidget *parent)
         : QObject(parent), plainTextEdit(qobject_cast<QPlainTextEdit *>(parent)),
           textEdit(qobject_cast<QTextEdit *>(parent)), edit(qobject_cast<QFrame *>(parent))
     {
         // parent must either inherit QPlainTextEdit or  QTextEdit!
         Q_ASSERT(plainTextEdit || textEdit);

         connect(parent, SIGNAL(textChanged()), this, SLOT(textEditChanged()));
         connect(parent, SIGNAL(cursorPositionChanged()), this, SLOT(textEditChanged()));
     }

 private Q_SLOTS:
     inline void textEditChanged();

 private:
     QPlainTextEdit *plainTextEdit;
     QTextEdit *textEdit;
     QFrame *edit;
 };

 void TextEditAutoResizer::textEditChanged()
 {
     QTextDocument *doc = textEdit ? textEdit->document() : plainTextEdit->document();
     QRect cursor = textEdit ? textEdit->cursorRect() : plainTextEdit->cursorRect();

     QSize s = doc->size().toSize();
     if (plainTextEdit)
         s.setHeight((s.height() + 1) * edit->fontMetrics().lineSpacing());

     const QRect fr = edit->frameRect();
     const QRect cr = edit->contentsRect();

     edit->setMinimumHeight(qMax(70, s.height() + (fr.height() - cr.height() - 1)));
     //edit->setMinimumWidth(qMax(70, s.width() + (fr.width() - cr.width() - 1)));

     // make sure the cursor is visible in case we have a QAbstractScrollArea parent
     QPoint pos = edit->pos();
     QWidget *pw = edit->parentWidget();
     while (pw) {
         if (pw->parentWidget()) {
             if (QAbstractScrollArea *area = qobject_cast<QAbstractScrollArea *>(
                             pw->parentWidget()->parentWidget())) {
                 if (QAbstractKineticScroller * scroller=
                         area->property("kineticScroller").value<QAbstractKineticScroller *>()) {
                     scroller->ensureVisible(pos + cursor.center(), 10 + cursor.width(),
                                             2 * cursor.height());
                 }
                 break;
             }
         }
         pos = pw->mapToParent(pos);
         pw = pw->parentWidget();
     }
 }


#endif // TEXTEDITAUTORESIZER_H
