#include "newdoc.h"
#include "ui_newdoc.h"
#include <QSettings>
#include "QFileInfo"
#include "qfile.h"
#include "qtextstream.h"

NewDoc::NewDoc(QWidget *parent, QString path) :
    QDialog(parent),
    ui(new Ui::NewDoc)
{
    ui->setupUi(this);
    path1 = path;
    QSettings settings("cepiperez","filemanager");
    settings.remove("NewDoc");
    settings.sync();
    ui->pushButton->setEnabled(false);
}

NewDoc::~NewDoc()
{
    delete ui;
}

void NewDoc::on_pushButton_2_clicked()
{
    this->close();
}

void NewDoc::on_pushButton_clicked()
{
    if ( ui->lineEdit->text() == "")
    {
        ui->errorlabel->setText( tr("Enter a valid file name") );
        return;
    }
    if ( QFileInfo(path1+"/"+ui->lineEdit->text()).exists() )
    {
        ui->errorlabel->setText( tr("The file already exists. Try another name") );
        return;
    }

    QString filename = path1+"/"+ui->lineEdit->text();
    QFile file( filename );
    if ( file.open( QFile::WriteOnly ) )
    {
        QTextStream stream( &file );
        stream << "" << endl;
        //QSettings settings("cepiperez","filemanager");
        //settings.setValue("NeedToRefresh", "Yes");
        this->close();
    }
    else
    {
        ui->errorlabel->setText( tr("Cannot create the file. Check permissions") );
    }


}

void NewDoc::on_lineEdit_textChanged(QString )
{
    if ( ui->lineEdit->text() == "" ) ui->pushButton->setEnabled(false);
    else ui->pushButton->setEnabled(true);
}
