#include "home.h"
#include "ui_home.h"
#include "qsettings.h"
#include "qmaemo5rotator.h"
#include <qdir.h>
#include <qfileinfo.h>

QString hPath;
QIcon ich;
QSettings hsettings("cepiperez", "filemanager");
QSettings hfoldericons("cepiperez", "filemanager_folders");
QSettings hfileicons("cepiperez", "filemanager_icons");


Home::Home(QWidget *parent, QString target, QString path, bool files) :
    QDialog(parent),
    ui(new Ui::Home)
{
    ui->setupUi(this);

    showfiles = files;
    target1 = target;

    if ( target1 == "Home" ) this->setWindowTitle(tr("Home folder"));
    if ( target1 == "Symlink" ) this->setWindowTitle(tr("Symlink destination"));
    if ( target1 == "CompressFolder" ) this->setWindowTitle(tr("Compress destination"));
    if ( target1 == "ExtractFolder" ) this->setWindowTitle(tr("Extract destination"));

    QSettings settings("cepiperez","filemanager");
    QString iconSet = settings.value("IconStyle", "Default").toString();

    ich = QPixmap("/opt/filebox/icons/" + iconSet + "/folder_up.png");
    ui->pushButton->setIcon( ich );

    QFileInfo dr(path);

    ich = QPixmap("/opt/filebox/icons/" + iconSet + "/homefolder.png");
    ui->button->setIcon( ich );
    ui->button->setText( dr.fileName() );
    if ( path == "/") ui->button->setText( "/" );
    ui->button->setValueText( path );
    if ( path == "/") ui->button->setValueText( "" );

    CargarBrowser( path );

    setAttribute(Qt::WA_Maemo5AutoOrientation, true);

}

Home::~Home()
{
    delete ui;
}

void Home::CargarBrowser(QString directorio)
{
    QSettings settings("cepiperez","filemanager");
    QString iconSet = settings.value("IconStyle", "Default").toString();

    hPath = directorio;
    QDir dir ( directorio, "*" );
    dir.setFilter ( QDir::Dirs | QDir::Hidden );
    if ( !dir.isReadable() )
          return;
    ui->button->setText( QFileInfo(directorio).fileName() );
    if ( directorio == "/") ui->button->setText( "/" );
    ui->button->setValueText( directorio );
    if ( directorio == "/") ui->button->setValueText( "" );

    ui->listWidget->clear();

    QStringList entries = dir.entryList();
    entries.sort();
    QStringList::ConstIterator it = entries.begin();


    if ( hsettings.value("ShowHiddenFiles", "No").toString() == "Yes" ) {
        if ( showfiles==true )
            dir.setFilter( QDir::AllEntries | QDir::Hidden | QDir::NoDotAndDotDot );
        else
            dir.setFilter( QDir::Dirs | QDir::Hidden | QDir::NoDotAndDotDot );
    } else {
        if ( showfiles==true )
            dir.setFilter( QDir::AllEntries | QDir::NoDotAndDotDot );
        else
            dir.setFilter( QDir::Dirs | QDir::NoDotAndDotDot );
    }
    dir.setSorting( QDir::Name | QDir::DirsFirst | QDir::IgnoreCase );

    //dir.setSorting( QDir::DirsFirst );
    QFileInfoList list = dir.entryInfoList();
    for (int i = 0; i < list.size(); ++i)
    {
      QFileInfo fileInfo = list.at(i);

        if ( fileInfo.isDir() )
        {

            QListWidgetItem *item1 = new QListWidgetItem( ui->listWidget );
            item1->setData(Qt::DisplayRole, fileInfo.fileName());

            QString itemname = fileInfo.fileName();
            QString ficon = hfoldericons.value(itemname, "general_folder.png").toString();

            if ( ! QFileInfo("/opt/filebox/icons/" + iconSet + "/folders/" + ficon).exists() )
                ficon = "general_folder.png";

            ich = QPixmap("/opt/filebox/icons/" + iconSet + "/folders/" + ficon );

            item1->setData(Qt::DecorationRole, ich);
            ui->listWidget->insertItem( i, item1 );

        }
        else if ( showfiles==true )
        {
            QListWidgetItem *item1 = new QListWidgetItem( ui->listWidget );
            item1->setData(Qt::DisplayRole, fileInfo.fileName());

            QString exten = fileInfo.completeSuffix();
            if ( exten != "note.html")
            {
                exten = fileInfo.fileName().toLower();
                int ei = exten.lastIndexOf( "." );
                if ( ei > 0 ) exten.remove ( 0, ei );
            }
            QString extension = hfileicons.value( exten, "file_other.png").toString();
            ich = QPixmap("/opt/filebox/icons/" + iconSet + "/mime/" + extension);

            item1->setData(Qt::DecorationRole, ich);
            ui->listWidget->insertItem( i, item1 );
        }

    }



    if ( ui->listWidget->count() > 0 ) {
        ui->listWidget->scrollToItem(ui->listWidget->item(0));
    }

}

void Home::on_listWidget_itemClicked(QListWidgetItem* item)
{
    QString temp = hPath;
    if ( temp != "/" ) temp.append("/");
    temp.append( item->text() );
    if ( temp == "//" ) temp="/";

    if ( QFileInfo(temp).isFile() && showfiles==true )
    {
        hsettings.setValue(target1, temp);
        this->close();
    }

    CargarBrowser( temp );
}

void Home::on_pushButton_clicked()
{
    if ( hPath == "/" ) return;
    QString nPath = hPath;
    int i = nPath.lastIndexOf( "/" );
    nPath.remove ( i, nPath.length() - i );
    if ( nPath == "" ) nPath = "/";
    CargarBrowser( nPath );

}

void Home::on_button_clicked()
{
    if ( ui->button->text() == "/" ) hsettings.setValue(target1, ui->button->text() );
    else hsettings.setValue( target1, ui->button->valueText() );
    hsettings.sync();
    this->close();
}
