/*
 * Copyright (C) 2010 Collabora Ltd.
 *   @author Xavier Claessens <xavier.claessens@collabora.co.uk>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA
 */

#include "config.h"

#include "ecs-window.h"

G_DEFINE_TYPE (EcsWindow, ecs_window, HILDON_TYPE_STACKABLE_WINDOW);

static void
ecs_window_init (EcsWindow *self)
{
  GtkWidget *label;

  label = gtk_label_new ("Extended Contacts Search is a plugin that extend "
      "the main view's live search algorithm. Additionally to search into "
      "contat's display name, it also look for nickname, phone numbers, "
      "emails, and IM usernames.\n\n"
      "Version running: " PACKAGE_VERSION);
  gtk_label_set_line_wrap (GTK_LABEL (label), TRUE);
  gtk_container_add (GTK_CONTAINER (self), label);
  gtk_widget_show (label);
}

static void
ecs_window_class_init (EcsWindowClass *klass)
{
}

GtkWidget *
ecs_window_new (void)
{
  return g_object_new (ECS_TYPE_WINDOW, "title", "Extended Contacts Search",
      NULL);
}

