import gobject
import gtk
import hildondesktop
import hildon
import dbus
import gnome.gconf as gconf
import pango
import cairo
import xml.dom.minidom as xmlparser
import urllib2 
import urllib
PATH = "/apps/digghomewidget"
CATGR = "/apps/digghomewidget/selected_category_int"
NUM = "/apps/digghomewidget/number_of_stories"
THMB = "/apps/digghomewidget/load_thumbnails"
FIRST = "/apps/digghomewidget/first_run"

gobject.threads_init()
#gtk.gdk.threads_init()

class diggItem:
    def __init__(self, title, href, topic, diggs):
        self.title = title
        self.href = href
        self.topic = topic
        self.diggs = diggs
        self.thumbnail = None


class diggLoader(gobject.GObject):
    def __init__(self, callback):
        self.__gobject_init__()
        self.callback = callback
        self.stream = ""
        self.load_thumbnails = True
        self.running = False
        self.list = None

    def read_and_return(self, data):#handle, data, result, read_bytes):
        doc = xmlparser.parseString(data)
        if doc != None:
            stories = doc.getElementsByTagName("story")
            if len(stories) == 0:
                return None
            list = []
            for story in stories:
                title = story.getElementsByTagName("title")[0]
                href = story.getElementsByTagName("shorturl")[0]
                title = title.childNodes[0].data
                href = href.getAttribute("short_url")
                diggs = story.getAttribute("diggs")
                topic = story.getElementsByTagName("topic")[0]
                topic = topic.getAttribute("name")
                item = diggItem(title, href, topic, diggs) 
                if self.load_thumbnails:
                    thumbnail = None
                    thumbnail = story.getElementsByTagName("thumbnail")
                    if thumbnail.length > 0:
                        thumbnail = thumbnail[0]
                        thumbnail = thumbnail.getAttribute("src")
                    try:
                        if thumbnail != None and thumbnail != "":
                            g = urllib.urlopen(thumbnail)
                            img = g.read()
                            item.thumbnail = img
                        #print item.thumbnail
                    except:
                        item.thumbnail = None
                list.append(item)
            self.list = list
            self.emit("data_loaded", "testi")

    def get_toplist(self, container="", topic="", count=2, hotness="top"):
        selected = ""
        if topic != "":
            selected = "topic/" + topic + "/"
        if container != "":
            container = container.replace("&", "_")
            selected = "container/" + container + "/"
        params = urllib.urlencode({"count":count, "appkey":"http://maemo.org/packages/view/digghomewidget/"})
        try:
            url = "http://services.digg.com/stories/"+selected+hotness+"?%s" % params
            f = urllib2.urlopen(url)
            data = f.read()
            self.read_and_return(data)
        except Exception, e:
            print "Can't connect to Digg.com", e

gobject.type_register(diggLoader)
gobject.signal_new("data_loaded", diggLoader, gobject.SIGNAL_RUN_FIRST,
                    gobject.TYPE_NONE, (str,))

class DiggItemWidget(hildon.Button):
    def __init__(self, item):
#        print inspect.getsourcelines(hildon.Button)
        hildon.Button.__init__(self, gtk.HILDON_SIZE_AUTO_WIDTH | gtk.HILDON_SIZE_FINGER_HEIGHT, hildon.BUTTON_ARRANGEMENT_VERTICAL)
#        self.set_app_paintable(True)
        self.item = item
        self.retval = self.connect("expose_event", self.expose)
        self.connect("clicked", self.click)

    def expose(self, widget, event):
        self.context = widget.window.cairo_create()
        self.context.rectangle(event.area.x, event.area.y,
                            event.area.width, event.area.height)

#        widget.draw_rectangle(self.context, True, 0, 0, 10, 10)
        self.context.clip()
        self.draw(self.context)
        return self.retval

    def draw(self, context):
#        print self.get_children()
        rect = self.get_allocation()
        context.rectangle(rect.x, rect.y, rect.width, rect.height)
#        print rect.height
        if self.state == 1:
            context.set_source_rgb(1.0, 0.4, 0.0)
        else: 
            context.set_source_rgb(1,1,1)
        context.fill()
        offset = 5
        if self.item.thumbnail != None:
            loader = gtk.gdk.PixbufLoader()
            loader.write(self.item.thumbnail)
            loader.close()
            offset = 70
            img = loader.get_pixbuf()
            img = img.scale_simple(54,54, gtk.gdk.INTERP_NEAREST)
            context.set_source_pixbuf(img, rect.x+8, rect.y+8)
            context.paint()
            context.rectangle(rect.x+5, rect.y+5, 60, 60)
            context.set_source_rgb(0.3, 0.3, 0.8)
            context.stroke()
        layout = context.create_layout()
        layout.set_text(self.item.title)
        layout.set_font_description(pango.FontDescription("Arial 13"))
        layout.set_wrap(pango.WRAP_WORD_CHAR)
        context.set_source_rgb(0.1, 0.3, 0.6)
        context.move_to(rect.x+offset, rect.y)
        layout.set_width(pango.SCALE*(300-offset))
#        print layout.get_pixel_size()
        if layout.get_line_count() > 2:
            layout.set_font_description(pango.FontDescription("Arial 11"))
        context.show_layout(layout)
        subtitle = context.create_layout()
        subtitle.set_text(self.item.diggs + " diggs, " + self.item.topic)
        subtitle.set_font_description(pango.FontDescription("Arial 10"))
        subtitle.set_wrap(pango.WRAP_WORD_CHAR)
        context.set_source_rgb(0.6, 0.6, 0.6)
        context.move_to(rect.x+offset, rect.y+rect.height-20)
        subtitle.set_width(pango.SCALE*(300-offset))
        context.show_layout(subtitle)


    def click(self, widget):
        bus = dbus.SystemBus()
        proxy = bus.get_object("com.nokia.osso_browser", 
                               "/com/nokia/osso_browser/request")
        int = dbus.Interface(proxy, dbus_interface="com.nokia.osso_browser")
        int.load_url(self.item.href)
        self.show_all()
                
class CustomButton(hildon.Button):
    def __init__(self, icon):
#        print inspect.getsourcelines(hildon.Button)
        hildon.Button.__init__(self, gtk.HILDON_SIZE_AUTO_WIDTH, hildon.BUTTON_ARRANGEMENT_VERTICAL)
        self.icon = icon
        self.set_size_request(150, 30)
        self.retval = self.connect("expose_event", self.expose)
        
    def expose(self, widget, event):
        self.context = widget.window.cairo_create()
        self.context.rectangle(event.area.x, event.area.y,
                            event.area.width, event.area.height)

        self.context.clip()
        rect = self.get_allocation()
        self.context.rectangle(rect.x, rect.y, rect.width, rect.height)
        self.context.set_source_rgb(0.1, 0.34, 0.564)
        if self.state == gtk.STATE_ACTIVE:
            self.context.set_source_rgb(0.2, 0.4, 0.7)
        self.context.fill()
        img = gtk.Image()
        img.set_from_file(self.icon)
        imgrect = img.get_allocation()
        self.context.set_source_pixbuf(img.get_pixbuf(), rect.x+(event.area.width/2-15), rect.y+1)
        self.context.paint()
        return self.retval

class CustomPickerButton(hildon.PickerButton):
    def __init__(self, icon):
#        print inspect.getsourcelines(hildon.Button)
        hildon.PickerButton.__init__(self, gtk.HILDON_SIZE_AUTO_WIDTH, hildon.BUTTON_ARRANGEMENT_VERTICAL)
        self.icon = icon
        self.set_size_request(150, 30)
        self.retval = self.connect("expose_event", self.expose)
        
    def expose(self, widget, event):
        self.context = widget.window.cairo_create()
        self.context.rectangle(event.area.x, event.area.y,
                            event.area.width, event.area.height)

        self.context.clip()
        rect = self.get_allocation()
        self.context.rectangle(rect.x, rect.y, rect.width, rect.height)
        self.context.set_source_rgb(0.1, 0.34, 0.564)
        if self.state == gtk.STATE_ACTIVE:
            self.context.set_source_rgb(0.2, 0.4, 0.7)
        self.context.fill()
        img = gtk.Image()
        img.set_from_file(self.icon)
        imgrect = img.get_allocation()
        self.context.set_source_pixbuf(img.get_pixbuf(), rect.x+60, rect.y+1)
        self.context.paint()
        return self.retval

class CustomAlignment(gtk.Alignment):
    def __init__(self, title):
        gtk.Alignment.__init__(self, 0.0, 0.0, 1.0, 1.0)
        self.title = title
        self.set_size_request(300, 16)
        self.retval = self.connect("expose_event", self.expose)

    def expose(self, widget, event):
        self.context = widget.window.cairo_create()
        self.context.rectangle(event.area.x, event.area.y,
                            event.area.width, event.area.height)

        self.context.clip()
        rect = self.get_allocation()
        self.context.rectangle(rect.x, rect.y, rect.width, rect.height)
        self.context.set_source_rgb(0.69, 0.82, 0.5)
        self.context.fill()
        layout = self.context.create_layout()
        layout.set_text(self.title)
        layout.set_font_description(pango.FontDescription("Arial 9"))
        self.context.set_source_rgb(1, 1, 1)
        self.context.move_to(rect.x+5, rect.y)
        self.context.show_layout(layout)
        return self.retval

    def update(self):
        pass
        

class DiggHomePlugin(hildondesktop.HomePluginItem):
    def __init__(self):
        hildondesktop.HomePluginItem.__init__(self)
#        print "ALL:", dir(self)
        self.set_default_size(300, 150)
        self.set_geometry_hints(self, 300, 100, 300, 600)
        self.set_settings(True)
        self.connect("show-settings", self.show_settings)
        self.loader = diggLoader(self.update) 
        self.client = gconf.client_get_default()
        try:
            temp_first = self.client.get_bool(FIRST)
            temp_cat = self.client.get_int(CATGR)
            temp_num = self.client.get_int(NUM)
            temp_check = self.client.get_bool(THMB)
        except:
            temp_first = False
            
        self.categories = []
        self.categories.append("")
        self.categories.append("Technology")
        self.categories.append("World&Business")
        self.categories.append("Entertainment")
        self.categories.append("Gaming")
        self.categories.append("Science")
        self.categories.append("Sports")
        self.categories.append("Lifestyle")
        self.categories.append("Offbeat")
        if temp_first == False:
            self.count = 2
            self.checkbox_active = True 
            self.loader.load_thumbnails = True 
            self.category = 0
            self.client.set_bool(THMB, self.loader.load_thumbnails)
            self.client.set_int(NUM, self.count)
            self.client.set_int(CATGR, self.category)
            self.client.set_bool(FIRST, True)
        else:
            if temp_cat != None and temp_cat !="" and temp_cat != 0:
                self.category = temp_cat 
            else:
                self.category = 0
            if temp_num != None and temp_num != 0:
                self.count = temp_num 
            else:
                self.count = 2
            if temp_check != None:
                self.checkbox_active = temp_check 
                self.loader.load_thumbnails = temp_check 
            else:
                self.checkbox_active = True 
                self.loader.load_thumbnails = True 
#        print "CAT:", self.category
        self.hotness = "Top"
        container = gtk.Alignment(0.0,0.0,1.0,1.0)
        container.set_padding(2,1,0,0)
        self.modify_bg(gtk.STATE_NORMAL, gtk.gdk.color_parse("#1B5790"))
#        container.set_app_paintable(True)        
        logo = gtk.Image()
        logo.set_from_file("/opt/digghomewidget/digg.png")
        #list = diggapi.get_toplist(container=self.category,count=self.count)
        mainVBox = gtk.VBox(spacing=1)
        mainVBox.add(logo)
        titletext = self.categories[self.category]
        if titletext == "":
            titletext = "All"
        #titletext = titletext +" > " + self.hotness# + " Updated 21.10.2009"
        self.row = CustomAlignment(titletext)
        mainVBox.add(self.row)
        self.vbox = gtk.VBox(spacing=1)
        self.vbox.set_size_request(-1, self.count*(70+1)-1)
        #if list != None and list != "":
        #    for item in list:
        #        button = DiggItemWidget(item)
        #        self.vbox.add(button)
        hbox = gtk.HBox(spacing=0)
        update = CustomButton("/opt/digghomewidget/update.png")
        update.connect("clicked", self.update_button)
        settings = CustomButton("/opt/digghomewidget/settings.png")
        settings.connect("clicked", self.change_topic)
        hbox.add(update)
        hbox.add(settings)
        mainVBox.add(self.vbox)
        mainVBox.add(hbox)
        container.add(mainVBox)
        container.show_all()
        self.add(container)
        self.connect("notify::is-on-current-desktop", self.on_desktop)
        self.set_size_request(300, 150)
        self.loader.connect("data_loaded", self.update)
        gobject.idle_add(self.loader.get_toplist, self.categories[self.category], "", self.count)
#        gtk.Settings.gtk-enable-animations = False

    def on_desktop(self, widget, data):
        self.resize(300, 150+(self.count-1)*(70+1))


    def update_button(self, widget):
        self.row.title = "Updating..."
        self.row.queue_draw()
        gobject.idle_add(self.loader.get_toplist, self.categories[self.category], "", self.count)
        #self.loader.get_toplist(container=self.categories[self.category],count=self.count)

    def change_topic(self, widget):
        dialog = gtk.Dialog()
        dialog.set_title("Settings")
        selector = hildon.TouchSelector(text = True) 
        selector.connect("changed", self.selection_changed)
        selector.append_text("All")
        selector.append_text("Technology")
        selector.append_text("World&Business")
        selector.append_text("Entertainment")
        selector.append_text("Gaming")
        selector.append_text("Science")
        selector.append_text("Sports")
        selector.append_text("Lifestyle")
        selector.append_text("Offbeat")
        selector.set_column_selection_mode(hildon.TOUCH_SELECTOR_SELECTION_MODE_SINGLE)
        categoryPicker = hildon.PickerButton(gtk.HILDON_SIZE_AUTO_WIDTH | gtk.HILDON_SIZE_FINGER_HEIGHT, hildon.BUTTON_ARRANGEMENT_VERTICAL)
        categoryPicker.set_alignment(0.0, 0.5, 1.0, 1.0)
        categoryPicker.set_title("Category")
        categoryPicker.set_selector(selector)
        categoryPicker.set_active(self.category)
        thumbn_checkbox = hildon.CheckButton(gtk.HILDON_SIZE_AUTO_WIDTH | gtk.HILDON_SIZE_FINGER_HEIGHT)
        thumbn_checkbox.set_label("Load thumbnails")
        thumbn_checkbox.set_active(self.loader.load_thumbnails)
        thumbn_checkbox.connect("toggled", self.checkbox_toggle)
        dialog.vbox.add(thumbn_checkbox)
        dialog.vbox.add(categoryPicker)
        dialog.add_button("Save", gtk.RESPONSE_OK)
        dialog.show_all()
        response = dialog.run()
        dialog.destroy()
        if response == gtk.RESPONSE_OK:
            self.loader.load_thumbnails = self.checkbox_active 
            self.client.set_bool(THMB, self.loader.load_thumbnails)
            self.category = categoryPicker.get_active() 
            self.client.set_string(CATGR, self.categories[self.category])
            self.update_button(self)
        
    def pickerValueChanged(self, button, user_data=None):
        self.pickerValue = button.get_value()
        

    def update(self, sender, success):
        list = sender.list
        if list != None:
            children = self.vbox.get_children()
            for child in children:
                self.vbox.remove(child)
            if list != None:
                for item in list:
                    button = DiggItemWidget(item)
                    self.vbox.pack_start(button, False)
                    button.show()
            self.queue_draw()
            self.client.set_string(CATGR, self.categories[self.category])
            title = self.categories[self.category]
            title = title.replace("_", "&")
            if title == "":
                title = "All"
            self.row.title = title 
        else:
            hildon.hildon_banner_show_information(self, "None", "Can't connect to digg.com. Please check your internet connection.")

    def selection_changed(self, selector, user_data):
        current_selection = selector.get_current_text()
#        print current_selection

    def show_settings(self, widget):
        dialog = gtk.Dialog()
        dialog.set_transient_for(self)
        dialog.set_title("Settings")
#        settings.connect("value-changed", self.category_changed)
        thumbn_checkbox = hildon.CheckButton(gtk.HILDON_SIZE_AUTO_WIDTH | gtk.HILDON_SIZE_FINGER_HEIGHT)
        thumbn_checkbox.set_label("Load thumbnails")
        dialog.add_button("Save", gtk.RESPONSE_OK)
        selector = hildon.TouchSelector(text = True)
        selector.append_text("1")
        selector.append_text("2")
        selector.append_text("3")
        selector.append_text("4")
        num_itemsPicker = hildon.PickerButton(gtk.HILDON_SIZE_AUTO_WIDTH | gtk.HILDON_SIZE_FINGER_HEIGHT, hildon.BUTTON_ARRANGEMENT_VERTICAL)
        num_itemsPicker.set_title("Number of stories")
        num_itemsPicker.set_selector(selector)
        num_itemsPicker.set_alignment(0.0, 0.5, 1.0, 1.0)
        num_itemsPicker.set_active(self.count-1)
        thumbn_checkbox.set_active(self.loader.load_thumbnails)
        thumbn_checkbox.connect("toggled", self.checkbox_toggle)
        dialog.vbox.add(num_itemsPicker)
#        dialog.vbox.add(thumbn_checkbox)
        dialog.show_all()
        response = dialog.run()
        dialog.destroy()
        if response == gtk.RESPONSE_OK:
            oldcount = self.count
            cursize = self.get_size()
            self.count = num_itemsPicker.get_active() + 1 
            sep = oldcount - self.count
            self.loader.load_thumbnails = self.checkbox_active 
            self.client.set_int(NUM, self.count)
            self.client.set_bool(THMB, self.loader.load_thumbnails)
            children = self.vbox.get_children()
            for child in children:
                self.vbox.remove(child)
            self.vbox.set_size_request(-1, self.count*(70+1)-1)
            self.set_size_request(300, cursize[1]-(sep*(70+1)))
            self.resize(300, cursize[1]-(sep*(70+1)))
            self.update_button(self)

    def checkbox_toggle(self, widget):
        self.checkbox_active =  widget.get_active()

hd_plugin_type = DiggHomePlugin

if __name__ == "__main__":
    import gobject
    gobject.type_register(hd_plugin_type)
    obj = gobject.new(hd_plugin_type, plugin_id="plugin_id")
    obj.show_all()
    gtk.main()
