/*
 * deskypplet: a maemo home applet for partial desktop experience
 * Copyright (C) 2011 sethkha 
 * partofit:Yellownotes
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option); any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */


/*
#include <hildon/hildon-program.h>
#include <libgnomevfs/gnome-vfs.h>*/

#include <dirent.h>
#include <gtk/gtk.h>
#include <hildon/hildon.h>
#include <stdlib.h>
#include <unistd.h>
#include <string.h>
#include <strings.h>
#include <sys/stat.h>
#include <sys/types.h>
#include <gdk-pixbuf/gdk-pixbuf.h>
#include <libhildondesktop/libhildondesktop.h>
#include "deskypplet.h"
#include <hildon-mime.h>
#include <libosso.h>
#include <sys/statvfs.h>
#include <glib.h>
#include <ctype.h>

YNCtx *app=NULL;

void adjust_settings(YNCtx *app)
{
	if(app->applet_x_size<MIN_X_SIZE)
		app->applet_x_size=MIN_X_SIZE;
	if(app->applet_x_size>MAX_X_SIZE)
		app->applet_x_size=MAX_X_SIZE;

	if(app->applet_y_size<MIN_Y_SIZE)
		app->applet_y_size=MIN_Y_SIZE;
	if(app->applet_y_size>MAX_Y_SIZE)
		app->applet_y_size=MAX_Y_SIZE;

	app->bg_alpha=1-(app->bg_alpha/100);
}

void load_applet_prefs(YNCtx *app)
{
	GIOChannel *f=NULL;
	GIOStatus st;
	GdkColormap *colormap;
	gchar *readbuf=NULL;
	gchar *fontbuffer=NULL;
	gchar *homedir=NULL;
	gchar *red=NULL;
	gchar *green=NULL;
	gchar *blue=NULL;
    homedir=(gchar *)getenv("HOME");
    check_config ();
	app->prefs_dir=g_new0(gchar,strlen(homedir)+strlen(SETTINGS_PATH)+5);
	sprintf(app->prefs_dir,"%s/%s",homedir,SETTINGS_PATH);	

	app->conf_file=g_new0(gchar,strlen(homedir)+strlen(SETTINGS_PATH)+strlen(PREFS_FILE)+5);
	sprintf(app->conf_file,"%s/%s/%s",homedir,SETTINGS_PATH,PREFS_FILE);

	app->locked=g_new0(gint,1);
	*app->locked=FALSE;

	g_print("Loading applet preferences\n");
	if(chdir(app->prefs_dir)<0)
	{
		g_print("Creating preferences directory\n");
		/*create settings directory in user's home*/
		if(mkdir(app->prefs_dir,(mode_t)0755) < 0)
			g_print("Error creating settings directory\n");
	}

	g_print("Loading default values\n");
	app->applet_x_size=APPLET_X_SIZE;
	app->applet_y_size=APPLET_Y_SIZE;
	gdk_color_parse (DEFAULT_COLOR, &(app->color));
	gdk_color_parse (DEFAULT_FONT_COLOR, &(app->fontcolor));
	app->fontname=g_new0(gchar,strlen(DEFAULT_FONT)+1);
	strcpy(app->fontname,DEFAULT_FONT);
	app->bg_alpha=(gfloat)DEFAULT_BG_ALPHA/100;
    app->work_dir="/home/user";
	
	f=g_io_channel_new_file(app->conf_file,"r",NULL);

	if(f!=NULL)
	{
		while((st=g_io_channel_read_line(f,&readbuf,NULL,NULL,NULL) )!=G_IO_STATUS_EOF)
		{
		
			if(strstr(readbuf,"width"))
				sscanf(readbuf,"width=%d\n",&(app->applet_x_size));
			if(strstr(readbuf,"height"))
				sscanf(readbuf,"height=%d\n",&(app->applet_y_size));
			if(strstr(readbuf,"bgcolor="))
			{
				red=strchr(readbuf,'=')+1;
				green=strchr(red,',');
				*green=0;
				green+=1;
				blue=strchr(green,',');
				*blue=0;
				blue+=1;
				fontbuffer=strchr(blue,'\n');
				*fontbuffer=0;
				(app->color).red=(guint16)atoi(red);
				(app->color).green=(guint16)atoi(green);
				(app->color).blue=(guint16)atoi(blue);
				colormap=gdk_colormap_get_system();
				gdk_colormap_alloc_color(colormap,&(app->color),TRUE,TRUE);
			}
			if(strstr(readbuf,"bgalpha"))
			{
				gint alpha;
				sscanf(readbuf,"bgalpha=%d\n",&alpha);
				app->bg_alpha=(gfloat)alpha/100;
			}
			
			if(strstr(readbuf,"center label"))
				sscanf(readbuf,"center label=%d\n",&(center_label));
			if(strstr(readbuf,"play mp3 folder"))
				sscanf(readbuf,"play mp3 folder=%d\n",&(mp3_default));
			if(strstr(readbuf,"execute sh files"))
				sscanf(readbuf,"execute sh files=%d\n",&(sh_exec_default));
			if(strstr(readbuf,"toolbar on top"))
				sscanf(readbuf,"toolbar on top=%d\n",&(toolbar_on_top));
			if(strstr(readbuf,"fastmode active on start"))
				sscanf(readbuf,"fastmode active on start=%d\n",&(fast_mode));
			if(strstr(readbuf,"use internal picture viewer"))
				sscanf(readbuf,"use internal picture viewer=%d\n",&(picviewer));
			if(strstr(readbuf,"fat finger mode"))
				sscanf(readbuf,"fat finger mode=%d\n",&(ff_mode));
			
			if(strstr(readbuf,"icons size"))
				sscanf(readbuf,"icons size=%d\n",&(app->icon_x_size));
			app->icon_y_size=app->icon_x_size;	
			app->icon_label_x_size=app->icon_x_size;
			if(strstr(readbuf,"title buttons size"))
				sscanf(readbuf,"title buttons size=%d\n",&(app->title_button_size));
			if(strstr(readbuf,"title height"))
				sscanf(readbuf,"title height=%d\n",&(app->title_height));
			if(strstr(readbuf,"filename textbox height"))
				sscanf(readbuf,"filename textbox height=%d\n",&(app->icon_label_y_size));					

			if(strstr(readbuf,"font for filenames="))
			{
				fontbuffer=strchr(readbuf,'\n');
				*fontbuffer=0;
				fontbuffer=strchr(readbuf,'=')+1;
				app->files_name_size=g_new0(gchar,strlen(fontbuffer)+1);
				strcpy(app->files_name_size,fontbuffer);
			}
			
			if(strstr(readbuf,"font for title="))
			{
				fontbuffer=strchr(readbuf,'\n');
				*fontbuffer=0;
				fontbuffer=strchr(readbuf,'=')+1;
				app->title_font_size=g_new0(gchar,strlen(fontbuffer)+1);
				strcpy(app->title_font_size,fontbuffer);
			}
			
			if(strstr(readbuf,"font for bookmarks="))
			{
				fontbuffer=strchr(readbuf,'\n');
				*fontbuffer=0;
				fontbuffer=strchr(readbuf,'=')+1;
				app->bookmarks_name_size=g_new0(gchar,strlen(fontbuffer)+1);
				strcpy(app->bookmarks_name_size,fontbuffer);
			}
	
			if(strstr(readbuf,"startdir="))
			{
				fontbuffer=strchr(readbuf,'\n');
				*fontbuffer=0;
				fontbuffer=strchr(readbuf,'=')+1;
				app->work_dir=g_new0(gchar,strlen(fontbuffer)+1);
				strcpy(app->work_dir,fontbuffer);
			}
			
			if(strstr(readbuf,"playlistdir="))
			{
				fontbuffer=strchr(readbuf,'\n');
				*fontbuffer=0;
				fontbuffer=strchr(readbuf,'=')+1;
				playlist_dir=g_new0(gchar,strlen(fontbuffer)+1);
				strcpy(playlist_dir,fontbuffer);
			}
			
			if(strstr(readbuf,"last app standing="))
			{
				fontbuffer=strchr(readbuf,'\n');
				*fontbuffer=0;
				fontbuffer=strchr(readbuf,'=')+1;
				last_app_standing=g_new0(gchar,strlen(fontbuffer)+1);
				strcpy(last_app_standing,fontbuffer);
			}
			
			if(strstr(readbuf,"fontcolor"))
			{
				red=strchr(readbuf,'=')+1;
				green=strchr(red,',');
				*green=0;
				green+=1;
				blue=strchr(green,',');
				*blue=0;
				blue+=1;
				fontbuffer=strchr(blue,'\n');
				*fontbuffer=0;
				(app->fontcolor).red=(guint16)atoi(red);
				(app->fontcolor).green=(guint16)atoi(green);
				(app->fontcolor).blue=(guint16)atoi(blue);
				colormap=gdk_colormap_get_system();
				gdk_colormap_alloc_color(colormap,&(app->fontcolor),TRUE,TRUE);
			}

			g_free(readbuf);
		}
		g_io_channel_close(f);
	}

	if (mp3_default==1)
		{mp3_play_status="Autoplay is on";}
	else
		{mp3_play_status="Autoplay is off";}

	if (sh_exec_default==1)
		{sh_exec_status="sh execute is on";}
	else
		{sh_exec_status="sh execute is off";}

	if (picviewer==1)
		{picviewer_status="Pic-viewer activated";}
	else
		{picviewer_status="Pic-viewer deactivated";}

	if (fast_mode==1)
		{mode_status="Fast Mode is on";}
	else
		{mode_status="Advanced Mode is on";}
	
	bookmarkview=0;
	app->home_dir=app->work_dir;
}

void select_bg_color(GObject *o, YNCtx *app)
{
	GdkColor newcolor;

	hildon_color_button_get_color(HILDON_COLOR_BUTTON(o),&newcolor);
	app->color=newcolor;
}

void select_font(GObject *o, YNCtx *app)
{
	g_free(app->fontname);
	app->fontname=g_new0(gchar,strlen(gtk_font_button_get_font_name(GTK_FONT_BUTTON(o)))+1);
	strcpy(app->fontname,gtk_font_button_get_font_name(GTK_FONT_BUTTON(o)));
}

void select_font_color(GObject *o, YNCtx *app)
{
	GdkColor newcolor;

	hildon_color_button_get_color(HILDON_COLOR_BUTTON(o),&newcolor);
	app->fontcolor=newcolor;
}

void set_cairo_transparency(GdkDrawable *drawable, GdkEventExpose *event, GdkColor color, gfloat alpha)
{
	cairo_t *cr;

	cr = gdk_cairo_create (drawable);
	gdk_cairo_region (cr, event->region);
	cairo_clip (cr);
	cairo_set_operator (cr, CAIRO_OPERATOR_SOURCE);
	cairo_set_source_rgba (cr, color.red/65535.0, color.green/65535.0, color.blue/65535.0, alpha);
	cairo_paint (cr);
  	cairo_destroy (cr);
}

void build_ui (void)
{ 
	GtkWidget *align;
	gchar* fullpath;
	fullpath=app->work_dir;
	GdkPixbuf *pixbuf=NULL; 
	PangoFontDescription *font_desc = pango_font_description_from_string (app->title_font_size); 
    
	GdkScreen *screen;
    
	app->frame= gtk_frame_new(NULL);
	gtk_container_set_border_width( GTK_CONTAINER( app->frame ), 0);

	app->vbox=gtk_vbox_new (FALSE, 0);
	gtk_container_set_border_width( GTK_CONTAINER( app->vbox ), 0);
    
    app->vbox_fb=gtk_vbox_new (FALSE, 0);
	gtk_container_set_border_width( GTK_CONTAINER( app->vbox ), 0);
    
    app->hbox_toolb=gtk_hbox_new (FALSE, 0);
	gtk_container_set_border_width( GTK_CONTAINER( app->hbox_toolb ), 0);
    
    app->scrolledwindow_fb=GTK_SCROLLED_WINDOW(gtk_scrolled_window_new(NULL,NULL));
    gtk_scrolled_window_set_policy(GTK_SCROLLED_WINDOW(app->scrolledwindow_fb), GTK_POLICY_AUTOMATIC, 
                     GTK_POLICY_AUTOMATIC);
	app->vscroll=gtk_scrolled_window_get_vscrollbar(app->scrolledwindow_fb);
	gtk_widget_set_app_paintable(app->vscroll,TRUE);
	
    screen = gtk_widget_get_screen (app->frame);
    g_signal_connect(screen, "size-changed", G_CALLBACK(on_orientation_changed),app);
    g_signal_connect (app->scrolledwindow_fb, "expose-event", G_CALLBACK (handle_expose),
                           app->scrolledwindow_fb);
    g_signal_connect (app->vscroll, "expose-event", G_CALLBACK (handle_expose_scrollbar),
                           app->vscroll);
	
    gtk_rc_parse_string(scroll_style);
     
    app->label_evbox=gtk_event_box_new ();
	gtk_event_box_set_visible_window(GTK_EVENT_BOX(app->label_evbox),FALSE);
	g_signal_connect(G_OBJECT(app->label_evbox),"button_release_event",G_CALLBACK(toggle_bookmark_view),app);
	 
    app->path_label=gtk_label_new (app->work_dir);
	gtk_widget_set_size_request (GTK_WIDGET(app->label_evbox),app->applet_x_size-160,app->title_height);
    gtk_label_set_line_wrap (GTK_LABEL (app->path_label),TRUE);
    gtk_label_set_line_wrap_mode (GTK_LABEL (app->path_label), PANGO_WRAP_WORD_CHAR);
    gtk_widget_modify_font (GTK_WIDGET(app->path_label), font_desc);
    
    if (center_label==1)
       {gtk_container_add (GTK_CONTAINER (app->label_evbox),app->path_label);}
   	else
       {
		align = gtk_alignment_new(0.0, 0.5, 0.0, 0.0);
        gtk_container_add(GTK_CONTAINER(align),app->path_label);
        gtk_container_add (GTK_CONTAINER (app->label_evbox),align);
        }
	
	/*gtk_widget_set_size_request (GTK_WIDGET(app->hbox_toolb),app->applet_x_size,40);*/
    
    pango_font_description_free (font_desc);
   
	app->folder_home_togglebox=gtk_vbox_new (TRUE, 0);
	gtk_box_pack_start(GTK_BOX(app->hbox_toolb),app->folder_home_togglebox,FALSE,FALSE,0);
	 
	pixbuf= gdk_pixbuf_new_from_file_at_size ("/home/user/.deskypplet/icons/folder_up.png",
	                                         app->title_button_size,app->title_button_size,NULL);   
	app->folder_up_image=gtk_image_new_from_pixbuf(pixbuf);
    app->folder_up_evbox=gtk_event_box_new ();
    gtk_event_box_set_visible_window(GTK_EVENT_BOX(app->folder_up_evbox),FALSE);
	gtk_container_add (GTK_CONTAINER (app->folder_up_evbox),app->folder_up_image);
	g_signal_connect(G_OBJECT(app->folder_up_evbox),"button_release_event",G_CALLBACK(go_folder_up),app);
		
	pixbuf= gdk_pixbuf_new_from_file_at_size ("/home/user/.deskypplet/icons/fastmode.png",
	                                         app->title_button_size,app->title_button_size,NULL);   
	app->folder_home_image=gtk_image_new_from_pixbuf(pixbuf);
	app->folder_home_evbox=gtk_event_box_new ();
	gtk_event_box_set_visible_window(GTK_EVENT_BOX(app->folder_home_evbox),FALSE);
	gtk_container_add (GTK_CONTAINER (app->folder_home_evbox),app->folder_home_image);
	g_signal_connect(G_OBJECT(app->folder_home_evbox),"button_release_event",G_CALLBACK(menu),app);
	
	/*pixbuf= gdk_pixbuf_new_from_file_at_size ("/home/user/.deskypplet/icons/advancedmode.png",
	                                         app->title_button_size,app->title_button_size,NULL);   
	app->adv_folder_home_image=gtk_image_new_from_pixbuf(pixbuf);
	app->folder_home_evbox_adv=gtk_event_box_new ();
	gtk_event_box_set_visible_window(GTK_EVENT_BOX(app->folder_home_evbox_adv),FALSE);
	gtk_container_add (GTK_CONTAINER (app->folder_home_evbox_adv),app->adv_folder_home_image);
	g_signal_connect(G_OBJECT(app->folder_home_evbox_adv),"button_release_event",G_CALLBACK(menu),app);*/
		
		  
	gtk_box_pack_end(GTK_BOX(app->folder_home_togglebox),app->folder_home_evbox,FALSE,FALSE,0);
	   
	create_table (app);
	
    gtk_box_pack_start(GTK_BOX(app->hbox_toolb),app->label_evbox,TRUE,TRUE,0);
    gtk_box_pack_end(GTK_BOX(app->hbox_toolb),app->folder_up_evbox,FALSE,FALSE,0);
    if (toolbar_on_top==1)
		{
		 gtk_box_pack_start(GTK_BOX(app->vbox),app->hbox_toolb,FALSE,FALSE,0);
		} 
    else 
		{
		 gtk_box_pack_end(GTK_BOX(app->vbox),app->hbox_toolb,FALSE,FALSE,0);
		}
    gtk_box_pack_end(GTK_BOX(app->vbox),app->vbox_fb/*scrolledwindow_fb*/,TRUE,TRUE,0);
	gtk_container_add (GTK_CONTAINER (app->vbox_fb), GTK_WIDGET(app->scrolledwindow_fb));
	gtk_container_add( GTK_CONTAINER( app->frame ), app->vbox );
	gtk_widget_show_all (GTK_WIDGET (app->frame));
}

static void deskypplet_plugin_init (DeskYppletPlugin *desktop_plugin)
{
	app = g_new0 (YNCtx, 1);
  
	load_applet_prefs(app);
	build_ui ();
		
	gtk_container_set_border_width( GTK_CONTAINER( desktop_plugin ), 0);
	gtk_container_add (GTK_CONTAINER (desktop_plugin), app->frame);
	hd_home_plugin_item_set_settings(HD_HOME_PLUGIN_ITEM(desktop_plugin),TRUE);
	gtk_window_resize( GTK_WINDOW (desktop_plugin), app->applet_x_size,app->applet_y_size);
    app->parent=desktop_plugin;
} 

static void deskypplet_plugin_class_init (DeskYppletPluginClass *class) 
{
    GtkWidgetClass *widget_class = GTK_WIDGET_CLASS (class);
    widget_class->realize = deskypplet_plugin_realize;
	widget_class->expose_event = deskypplet_plugin_expose_event;
} 

static void deskypplet_plugin_class_finalize (DeskYppletPluginClass *class) {} 

static void deskypplet_plugin_realize (GtkWidget *widget)
{
    GdkScreen *screen;

    screen = gtk_widget_get_screen (widget);
    gtk_widget_set_colormap (widget,gdk_screen_get_rgba_colormap (screen));
    gtk_widget_set_app_paintable (widget,TRUE);

    GTK_WIDGET_CLASS (deskypplet_plugin_parent_class)->realize (widget);
}

static gboolean deskypplet_plugin_expose_event(GtkWidget *widget, GdkEventExpose *event)
{
	set_cairo_transparency(GDK_DRAWABLE (widget->window),event,app->color,app->bg_alpha);
	return GTK_WIDGET_CLASS (deskypplet_plugin_parent_class)->expose_event (widget,event);
}

static gboolean handle_expose (GtkWidget *widget, GdkEventExpose *event)
{
	cairo_t *cr;

	cr = gdk_cairo_create (GDK_DRAWABLE (widget->window));
	gdk_cairo_region (cr, event->region);
	cairo_clip (cr);
	cairo_set_operator (cr, CAIRO_OPERATOR_SOURCE);
	cairo_set_source_rgba (cr, (app->color).red, (app->color).green, (app->color).blue, app->bg_alpha);
	cairo_paint (cr);
	cairo_destroy (cr);

	return FALSE;
}

static gboolean handle_expose_scrollbar (GtkWidget *widget, GdkEventExpose *event)
{
	cairo_t *cr;

	cr = gdk_cairo_create (GDK_DRAWABLE (widget->window));
	gdk_cairo_region (cr, event->region);
	cairo_clip (cr);
	cairo_set_operator (cr, CAIRO_OPERATOR_SOURCE);
	cairo_set_source_rgba (cr, 0.0, 0.0, 0.0, 0.0);
	cairo_paint (cr);
	cairo_destroy (cr);

	return FALSE;
}

static gboolean is_portrait ()
{
	GdkScreen *screen = gdk_screen_get_default();
	
	int width = gdk_screen_get_width(screen);
	int height = gdk_screen_get_height(screen);
	if (width > height) 
		{
		 return FALSE;
		} 
	else 
		{
		 return TRUE;
		}
}
 
void on_orientation_changed(GdkScreen *screen, YNCtx *app)
{
	int i=0;
	
	if (is_portrait()) 
		{
		 if (app->applet_x_size==800) {app->applet_x_size=720;}
		 if (app->applet_y_size==420) {app->applet_y_size=480;}
		 i=app->applet_y_size;app->applet_y_size=app->applet_x_size;app->applet_x_size=i;
		 gtk_window_resize(GTK_WINDOW(app->parent),app->applet_x_size,app->applet_y_size);
		} 
   else 
		{
		 if (app->applet_y_size==720) {app->applet_y_size=800;}
		 if (app->applet_x_size==480) {app->applet_x_size=420;}
		 i=app->applet_y_size;app->applet_y_size=app->applet_x_size;app->applet_x_size=i;
         gtk_window_resize(GTK_WINDOW(app->parent),app->applet_x_size,app->applet_y_size);
		}
	gtk_widget_destroy(app->table);
	create_table (app);
	
	return;
}

static gboolean is_mp3_folder (gchar *fullpath)
{
	int oth=0,sou=0;
	char *sou_chk;
	
	if((dir=opendir(fullpath)) == NULL) 
		{fprintf(stderr,"Error opendir ...\n");return FALSE;}
    while((dirpointer=readdir(dir)) != NULL)
		{ sou_chk=g_strconcat ((*dirpointer).d_name,NULL);
         /*printf("is_mp3_folder FILE %s\n",sou_chk);*/
		 if (strstr(sou_chk, ".mp3"))
			{
			 sou++;
			}
		 else 
			{
			 oth++; 
			 if (oth>6) 
				{
				 if(closedir(dir) == -1) {printf("Error closing dir\n");}
				 return FALSE;
				}
			}
		}
	if(closedir(dir) == -1) 
	  {printf("Error closing dir\n");}
	if (sou>2) 
	  {
	   return TRUE;
	   }
	
	return FALSE;
}

void icon_tap (GObject *o,GdkEventButton *event,gchar *fullpath)
{   
	/*printf ("icon_tap FULLPATH %s\n",fullpath);*/
	stat(fullpath, &buf);
 	
	if(S_ISDIR(buf.st_mode))
		{
		 if ((mp3_default==1) && (is_mp3_folder (fullpath)))
			{
			 play_folder (fullpath);
			 return;
			}
		 else
			{
			 change_folder (fullpath);
			}
		}	
	else
		{
		 if (sh_exec_default==1)
			{
			 if ((strstr (fullpath,".sh"))||strstr(fullpath,".SH"))
				{
				 gchar *exec_sh_com;
				 exec_sh_com=g_strconcat ("osso-xterm -e ",fullpath," &","\0",NULL);
				 system (exec_sh_com);
				 return;
				}
			}
		 else
			{
			 handle_mime (fullpath);
			 }
		}  
   
	return;
}

void change_folder (gchar *fullpath)
{   
    /*printf ("change_folder FULLPATH %s\n",fullpath);*/
    app->work_dir=fullpath;
    gtk_widget_destroy(app->table);
	create_table (app);
	
	return;
}

void change_folder2 (gpointer button,gchar *fullpath)
{   
    /*printf ("change_folder2 FULLPATH %s\n",fullpath);*/
    app->work_dir=fullpath;
    gtk_widget_destroy(dialog);
	gtk_widget_destroy(app->table);
	create_table (app);
	
	return;
}

void icon_tap_advanced (GObject *o,GdkEventButton *event,gchar *fullpath)
{   
    stat(fullpath, &buf);
	
	if(S_ISDIR(buf.st_mode))
      {
	   menu_folders (fullpath);
	   }	
    else
      {
	   menu_files (fullpath);
       }  
  
    return;
}

void go_folder_up (GObject *o,GdkEventButton *event,YNCtx *app)
{
	char dirpath[1024] = { 0 }; 
    gchar *pointr=NULL;    
    
    pointr = strrchr(app->work_dir,'/');
	size_t n = pointr - app->work_dir + strlen("/") ;
	memcpy(dirpath, app->work_dir, n);
	dirpath[n-1] ='\0';   
    app->work_dir=g_strconcat (dirpath,"\0",NULL);
    if (dirpath[1]==0) 
		{
		 app->work_dir="/";
		}
	gtk_widget_destroy(app->table);
	create_table (app);
   
    return;
}

GdkPixbuf *get_pixbuf_folder (gchar *fullpath)
{   
	FILE *file;
	GdkPixbuf *pixbuf=NULL; 
	char *basename = strrchr(fullpath, '/') + 1;
	gchar *dirpeg=g_strconcat (fullpath,"/folder.jpg",NULL);
	gchar *dirpeg2=g_strconcat (fullpath,"/",basename,".jpg",NULL);
	gchar *dirpeg3=g_strconcat (fullpath,"/folder.png",NULL);
	gchar *dirpeg4=g_strconcat (fullpath,"/cover.jpg",NULL);
		 
	file = fopen(dirpeg, "r");
	if (file)  
		{
		 fclose(file);
		 pixbuf= gdk_pixbuf_new_from_file_at_size (dirpeg,app->icon_x_size,app->icon_y_size,NULL);   
		 return pixbuf;
		}   
	else 
		{ 
		 file = fopen(dirpeg2, "r");
		 if (file)  
			{
			 fclose(file);
			 pixbuf= gdk_pixbuf_new_from_file_at_size (dirpeg2,app->icon_x_size,app->icon_y_size,NULL);   
			 return pixbuf;
			 }
		 else 
			{ 
			 file = fopen(dirpeg3, "r");
			 if (file)  
				{
				 fclose(file);
				 pixbuf= gdk_pixbuf_new_from_file_at_size (dirpeg3,app->icon_x_size,app->icon_y_size,NULL);   
				 return pixbuf;
				 }   
			 else  
				{ 
				 file = fopen(dirpeg4, "r");
				 if (file)  
					{
					 fclose(file);
					 pixbuf= gdk_pixbuf_new_from_file_at_size (dirpeg4,app->icon_x_size,app->icon_y_size,NULL);   
					 return pixbuf;
					}   
				 else  
					{
					 pixbuf=gdk_pixbuf_new_from_file_at_size("/home/user/.deskypplet/icons/folder.png",
					                                    app->icon_x_size,app->icon_y_size,NULL);
					 return pixbuf;
					}
				}
			}
		}
			   
}

GdkPixbuf *get_pixbuf_file (gchar *fullpath)
{   
	GdkPixbuf *pixbuf=NULL; 
	struct stat statbuf;
	int counter=0;
	char mychar;
	char xxx[50];
	char *mime_icon_name=NULL;
	gchar *mime_icon_file=NULL;
	gchar *test;
	
	if (strstr(fullpath, "/folder.png"))
		{
		 pixbuf=gdk_pixbuf_new_from_file_at_size ("/home/user/.deskypplet/icons/folderpic.png",
		                                     app->icon_x_size,app->icon_y_size,NULL);
		 return pixbuf;
		}
	else if ((pixbuf= gdk_pixbuf_new_from_file_at_size (fullpath,app->icon_x_size,app->icon_y_size,NULL))!=NULL)   
		{
		 return pixbuf;
		}
	else
		{
		 mime_icon_name=NULL;
		 if ((mime_icon_name=strrchr(fullpath, '.'))==0)
			{
			 test=g_strconcat (fullpath,"\0",NULL);
			 /*printf ("get_pixbuf_file TEST    %s\n",test);*/
			 
			 if (stat(test, &statbuf) >= 0) 
			 	{ 
                 if ((statbuf.st_mode &S_IXUSR))
					{
					 /*printf ("get_pxbuf_file FULLPATH %s\n",fullpath);
					 printf ("exe\n");*/
					 mime_icon_name=g_strconcat (".noext-exe","\0",NULL);
					}
				 else
					{
					 /*printf ("get_pxbuf_file FULLPATH %s\n",fullpath);
					 printf ("no exe\n");*/
					 mime_icon_name=g_strconcat (".noext","\0",NULL);
					}
				}
			}
			
         counter=0;
		 while (mime_icon_name[counter]!=0)
			{
			 mychar=mime_icon_name[counter];
			 xxx[counter]=(tolower(mychar));
			 counter++;
			}
		 /*printf ("xxx    %s\n",xxx);*/
		 mime_icon_file=g_strconcat ("/home/user/.deskypplet/icons/",xxx+1,".png",NULL);
		 /*printf ("create_table MIME_ICON_NAME %s\n",mime_icon_name);
		 printf ("create_table MIME_ICON_FILE %s\n",mime_icon_file);*/
		 if ((pixbuf= gdk_pixbuf_new_from_file_at_size(mime_icon_file,app->icon_x_size,app->icon_y_size,NULL))!=0)
			{
			 return pixbuf;
			}
		 else
			{
			 pixbuf= gdk_pixbuf_new_from_file_at_size("/home/user/.deskypplet/icons/dummy.png",
								                    	app->icon_x_size,app->icon_y_size,NULL);
			 return pixbuf;
			}
		}
}

void create_table (YNCtx *app)
{
	GdkPixbuf *pixbuf=NULL; 
	char *name_files[700]={NULL};
	char *name_folders[300]={NULL};
	int i=0,j=0,a=0,n_files=0,n_folders=0;
	int table_rows;
	gchar *fullpath=NULL;
	
	table_rows=(app->applet_x_size/(app->icon_x_size+6))-1;
	GtkWidget *table_file_label;
	GtkWidget *table_label_evbx;
    GtkWidget *table_file_evbx=NULL;
    GtkWidget *table_file_img; 
    GtkJustification textjustify = GTK_JUSTIFY_CENTER;
	PangoFontDescription *font_desc = pango_font_description_from_string (app->files_name_size); 
    app->table = gtk_table_new (table_rows,table_rows, FALSE);
    gtk_table_set_row_spacings (GTK_TABLE (app->table), 3);
    gtk_table_set_col_spacings (GTK_TABLE (app->table), 3);

    if((dir=opendir(app->work_dir)) == NULL) {fprintf(stderr,"Error opendir ...\n");return ;}

    while((dirpointer=readdir(dir)) != NULL)
		{ 
		 if (strcmp((*dirpointer).d_name, ".") != 0 && strcmp((*dirpointer).d_name, "..") != 0)
			{ 
			 if (strcmp(app->work_dir, "/") == 0) 
				{
				 fullpath=g_strconcat (app->work_dir, (*dirpointer).d_name,NULL);
				 }
			 else 
				{
				 fullpath=g_strconcat (app->work_dir,"/", (*dirpointer).d_name,NULL);
				 }
			 stat(fullpath, &buf);
             if(S_ISDIR(buf.st_mode))
				{
				 name_folders[n_folders]=g_strconcat ((*dirpointer).d_name,NULL);
				 /*printf("create_table NAME_FOLDERS %s\n",name_folders [n_folders]);*/
				 n_folders++;
				} 
			 else
				{
				 name_files[n_files]=g_strconcat ((*dirpointer).d_name,NULL);
				 /*printf("create_table NAME_FILES %s\n",name_files [n_files]);*/
				 n_files++;
				}   
			}
		}
    if(closedir(dir) == -1) {printf("Error closing dir\n");}
     
    qsort(name_folders, n_folders, sizeof name_folders[0],&myComparisonFunction);
    qsort(name_files, n_files, sizeof name_files[0],&myComparisonFunction);
        
    for (a = 0; a < n_folders+n_files; a++) 
		{
		 table_file_evbx=gtk_event_box_new ();
	     i++;if (i>table_rows) {i=1;j=j+2;}
		 if (strcmp(app->work_dir, "/") == 0) 
			{
			 if (a>=n_folders)
				{
				 fullpath=g_strconcat (app->work_dir, name_files[a-n_folders],"\0",NULL);
				 table_file_label=gtk_label_new (name_files[a-n_folders]);
				 /*table_file_img=gtk_image_new_from_pixbuf(get_pixbuf_file (fullpath));*/
				 }
			 else
				{
				 fullpath=g_strconcat (app->work_dir, name_folders[a],"\0",NULL);
				 table_file_label=gtk_label_new (name_folders[a]);
				 /*table_file_img=gtk_image_new_from_pixbuf(get_pixbuf_folder (fullpath));*/
			 	}
			}
	     else 
			{
			 if (a>=n_folders)
				{
				 fullpath=g_strconcat (app->work_dir,"/", name_files[a-n_folders],"\0",NULL);
				 table_file_label=gtk_label_new (name_files[a-n_folders]);
				 /*table_file_img=gtk_image_new_from_pixbuf(get_pixbuf_file (fullpath));*/
				}
			 else
				{
				 fullpath=g_strconcat (app->work_dir,"/", name_folders[a],"\0",NULL);
				 table_file_label=gtk_label_new (name_folders[a]);
				 /*table_file_img=gtk_image_new_from_pixbuf(get_pixbuf_folder (fullpath));*/
			 	}
			}
		 stat(fullpath, &buf);
		 /*printf ("create_table FULLPATH %s\n",fullpath);*/
		 
		 if(S_ISDIR(buf.st_mode))
			{
			 table_file_img=gtk_image_new_from_pixbuf(get_pixbuf_folder (fullpath));
			 }
		 else
			{
			 table_file_img=gtk_image_new_from_pixbuf(get_pixbuf_file (fullpath));
			}
		
		 gtk_container_add (GTK_CONTAINER (table_file_evbx),table_file_img);
	     table_label_evbx=gtk_event_box_new ();
	 	
         gtk_widget_set_size_request (GTK_WIDGET(table_label_evbx),app->icon_label_x_size,app->icon_label_y_size);
         gtk_widget_set_size_request (GTK_WIDGET(table_file_label),app->icon_label_x_size,app->icon_label_y_size);
         gtk_widget_modify_font (GTK_WIDGET(table_file_label), font_desc);
         gtk_label_set_justify (GTK_LABEL (table_file_label),textjustify);
         gtk_label_set_line_wrap (GTK_LABEL (table_file_label),TRUE);
		 gtk_label_set_line_wrap_mode (GTK_LABEL (table_file_label), PANGO_WRAP_WORD_CHAR);
		 gtk_misc_set_alignment(GTK_MISC(table_file_label), 0.5f, 0.0f);  
		 gtk_widget_set_size_request (GTK_WIDGET(table_file_img),app->icon_x_size,app->icon_y_size);
		 if (fast_mode==1)
			{	
			 g_signal_connect(G_OBJECT(table_file_evbx),"button_release_event", G_CALLBACK(icon_tap),fullpath);
			 if (ff_mode==1)
				{
				 g_signal_connect(G_OBJECT(table_label_evbx),"button_release_event", G_CALLBACK(icon_tap),fullpath);
				}
			 else
				{
				 g_signal_connect(G_OBJECT(table_label_evbx),"button_release_event", G_CALLBACK(icon_tap_advanced),fullpath);
				}
			}
		 else
			{	
			 g_signal_connect(G_OBJECT(table_file_evbx),"button_release_event", G_CALLBACK(icon_tap_advanced),fullpath);
			 if (ff_mode==1)
				{
				 g_signal_connect(G_OBJECT(table_label_evbx),"button_release_event", G_CALLBACK(icon_tap_advanced),fullpath);
				}
			 else
				{
				 g_signal_connect(G_OBJECT(table_label_evbx),"button_release_event", G_CALLBACK(icon_tap),fullpath);
				}
			}
	 
		 gtk_event_box_set_visible_window(GTK_EVENT_BOX(table_file_evbx),FALSE);
	     gtk_event_box_set_visible_window(GTK_EVENT_BOX(table_label_evbx),FALSE);
	     gtk_container_add (GTK_CONTAINER (table_label_evbx),table_file_label);
		 gtk_table_attach_defaults (GTK_TABLE (app->table), table_file_evbx,i,i+1,j,j+1);
		 gtk_table_attach_defaults (GTK_TABLE (app->table), table_label_evbx,i,i+1,j+1,j+2);
		}
     
    if (fast_mode==1)
		{
	     pixbuf= gdk_pixbuf_new_from_file_at_size ("/home/user/.deskypplet/icons/fastmode.png",
	                                         app->title_button_size,app->title_button_size,NULL);   
	    }
	else
		{
		 pixbuf= gdk_pixbuf_new_from_file_at_size ("/home/user/.deskypplet/icons/advancedmode.png",
	                                         app->title_button_size,app->title_button_size,NULL);   
		}
	
	pango_font_description_free (font_desc);  	
	gtk_image_set_from_pixbuf(GTK_IMAGE (app->folder_home_image),pixbuf);
	font_desc = pango_font_description_from_string (app->title_font_size);
    g_signal_connect (app->table, "expose-event", G_CALLBACK (handle_expose),app->table);
    /*g_signal_connect (app->path_label, "expose-event", G_CALLBACK (set_cairo_transparency),app->path_label);*/
     
   	gtk_widget_set_size_request (GTK_WIDGET(app->label_evbox),app->applet_x_size-160,app->title_height);
    gtk_label_set_text (GTK_LABEL (app->path_label),app->work_dir);
   	gtk_widget_modify_font (GTK_WIDGET(app->path_label), font_desc);
       
   	pango_font_description_free (font_desc);
   
    gtk_scrolled_window_add_with_viewport (GTK_SCROLLED_WINDOW (app->scrolledwindow_fb), app->table);
   	gtk_widget_show_all (GTK_WIDGET (app->frame));
   		  
	return;
}

int myComparisonFunction(const void *x, const void *y) 
{
	return (strcmp(*(const char **)x, *(const char **)y));
}

void menu ()
{
	gchar *com_com=NULL;
	gchar *com_do1=NULL;
	gchar *com_do2=NULL;
	gchar *title;
	gchar *title_capa;
	gchar *title_free;
	char delims[] = "@";
	char var [100],value[100],line[200];
	int i=0;
	GtkWidget *vbox=NULL;
	GtkWidget *hbox=NULL;
	GtkWidget *button=NULL;
	/*GtkWidget *button_term=NULL;*/
	GtkWidget *button_t_mp3=NULL;
	GtkWidget *button_t_sh=NULL;
	GtkWidget *button_t_md=NULL;
	GtkWidget *button_t_pv=NULL;
	GtkWidget *button_help=NULL;
	GtkWidget *pannable_area=NULL;
    GtkWidget *table=NULL;
		
	title_capa=g_get_capacity (app->work_dir);
	title_free=g_get_free_space (app->work_dir);
	title=g_strconcat ("free ",title_free," / ",title_capa,"\0",NULL);
	
	dialog=gtk_dialog_new_with_buttons(title,NULL, 0,0,0,0,0,NULL);
	gtk_widget_set_size_request (GTK_WIDGET(dialog),-1,800); 
    
    hbox=gtk_hbox_new(TRUE,0);
	vbox=gtk_vbox_new(TRUE,0);
	
	pannable_area = hildon_pannable_area_new ();
	/*gtk_widget_set_size_request (GTK_WIDGET(pannable_area),app->applet_x_size-20,-1);*/
	table = gtk_table_new (40,2, FALSE);
    gtk_table_set_row_spacings (GTK_TABLE (table), 2);
    gtk_table_set_col_spacings (GTK_TABLE (table), 2);
     
	i=0;
	FILE *fp=fopen("/home/user/.deskypplet/yppletactions.conf","r");
	if (fp) 
      {
	   while (fgets(line,sizeof(line),fp))
          {
	       i++;
	       /* memset (var,0,sizeof(var));
           memset (value,0,sizeof(value));*/
		   sscanf(line,"%[^'=']=%[^\'#'\n]%*[\t]%*[\t]",var,value);  
		  
		  com_do1=strtok( value, delims );
          com_do2=strtok( NULL, delims );
          com_com=g_strconcat (com_do1,app->work_dir,com_do2,"\0",NULL);
		   
		   button = hildon_button_new_with_text (HILDON_SIZE_AUTO_WIDTH | HILDON_SIZE_FINGER_HEIGHT,
			    			       HILDON_BUTTON_ARRANGEMENT_VERTICAL, var,0);
	       g_signal_connect (button, "clicked", G_CALLBACK (custom_com),com_com);
           gtk_button_set_alignment (GTK_BUTTON(button),0,0.5);				       
	  
           gtk_table_attach_defaults (GTK_TABLE (table), button,1,2,i,i+1);
           
          /*  printf ("\n var %s\n",var);
		   printf (" value %s\n",value);
		   printf ("com_do1 %s\n",com_do1);
		   printf ("com_do2 %s\n",com_do2);
		   printf ("com_com %s\n",com_com);*/
		   }
	   fclose (fp);
	   }
	   
	/*button_term = hildon_button_new_with_text (HILDON_SIZE_AUTO_WIDTH | HILDON_SIZE_FINGER_HEIGHT,
	                				       HILDON_BUTTON_ARRANGEMENT_VERTICAL,"Terminal here",NULL);
	g_signal_connect (button_term, "clicked", G_CALLBACK (term_her),NULL);
    gtk_button_set_alignment (GTK_BUTTON(button_term),0,0.5);				       
	gtk_table_attach_defaults (GTK_TABLE (table), button_term,2,3,1,2);  */
	
	button_t_mp3 = hildon_button_new_with_text (HILDON_SIZE_AUTO_WIDTH | HILDON_SIZE_FINGER_HEIGHT,
	                				       HILDON_BUTTON_ARRANGEMENT_VERTICAL,mp3_play_status,NULL);
	g_signal_connect (button_t_mp3, "clicked", G_CALLBACK (toggle_mp3_play),NULL);
    gtk_button_set_alignment (GTK_BUTTON(button_t_mp3),0,0.5);				       
	gtk_table_attach_defaults (GTK_TABLE (table), button_t_mp3,2,3,2,3);  
	
	button_t_sh = hildon_button_new_with_text (HILDON_SIZE_AUTO_WIDTH | HILDON_SIZE_FINGER_HEIGHT,
	                				       HILDON_BUTTON_ARRANGEMENT_VERTICAL,sh_exec_status,NULL);
	g_signal_connect (button_t_sh, "clicked", G_CALLBACK (toggle_exec_sh),NULL);
    gtk_button_set_alignment (GTK_BUTTON(button_t_sh),0,0.5);				       
	gtk_table_attach_defaults (GTK_TABLE (table), button_t_sh,2,3,3,4);  
	
	button_t_md = hildon_button_new_with_text (HILDON_SIZE_AUTO_WIDTH | HILDON_SIZE_FINGER_HEIGHT,
	                				       HILDON_BUTTON_ARRANGEMENT_VERTICAL,mode_status,NULL);
	g_signal_connect (button_t_md, "clicked", G_CALLBACK (toggle_mode),NULL);
    gtk_button_set_alignment (GTK_BUTTON(button_t_md),0,0.5);				       
	gtk_table_attach_defaults (GTK_TABLE (table), button_t_md,2,3,1,2);  
	
	button_t_pv = hildon_button_new_with_text (HILDON_SIZE_AUTO_WIDTH | HILDON_SIZE_FINGER_HEIGHT,
	                				       HILDON_BUTTON_ARRANGEMENT_VERTICAL,picviewer_status,NULL);
	g_signal_connect (button_t_pv, "clicked", G_CALLBACK (toggle_picviewer),NULL);
    gtk_button_set_alignment (GTK_BUTTON(button_t_pv),0,0.5);				       
	gtk_table_attach_defaults (GTK_TABLE (table), button_t_pv,2,3,5,6);  
	
	button_help = hildon_button_new_with_text (HILDON_SIZE_AUTO_WIDTH | HILDON_SIZE_FINGER_HEIGHT,
	                				       HILDON_BUTTON_ARRANGEMENT_VERTICAL,"help",NULL);
	g_signal_connect (button_help, "clicked", G_CALLBACK (call_help),NULL);
    gtk_button_set_alignment (GTK_BUTTON(button_help),0,0.5);				       
	gtk_table_attach_defaults (GTK_TABLE (table), button_help,2,3,4,5);  
	
	hildon_pannable_area_add_with_viewport (HILDON_PANNABLE_AREA (pannable_area),table);
    gtk_container_add (GTK_CONTAINER (hbox), pannable_area);
    
    gtk_container_add (GTK_CONTAINER (GTK_DIALOG(dialog)->vbox),hbox);
	
	gtk_widget_show_all(dialog);
	gtk_dialog_run (GTK_DIALOG(dialog));
	
	return;
}

void bookmark_tapped (GObject *o,GdkEventButton *event,gchar *fullpath)
{  
	/*printf ("bookmark_tapped FULLPATH %s\n",fullpath);*/
	app->work_dir=fullpath;
	gtk_widget_destroy(app->table);
	create_table (app);
   	
    return;
}

void custom_com (gpointer button,gchar *com_do)
{   
	/*printf ("custom_com COM_DO %s\n",com_do);*/
    system (com_do);
	gtk_widget_destroy(app->table);
	create_table (app);
   	gtk_widget_destroy(dialog);
	
	return;
}

/*void term_her ()
{   
	FILE *f=NULL;

	f=fopen("/home/user/.deskypplet/deskypplet-terminal","w");
	if(f!=NULL)
	{
		fprintf(f,"#!/bin/sh\n");
		fprintf(f,"cd %s \n",app->work_dir);
		fprintf(f,"/bin/sh\n");
		fclose(f);
	}
	system ("chmod +x /home/user/.deskypplet/deskypplet-terminal &");
	system ("osso-xterm /home/user/.deskypplet/deskypplet-terminal &");
	gtk_widget_destroy(dialog);
	return;
}*/

void book_this (GObject *o,GdkEventButton *event)
{   
	gchar *fullpath;
	char line[150],value[150];
	char *bookm[150];
	int i=0,j=0;
	
	FILE *fp=fopen("/home/user/.deskypplet/ypplet-bookmarks.conf","r");
	if (fp) 
		{
		 while (fgets(line,sizeof(line),fp))
			{
			 /*printf ("book_this LINE %s\n",line);*/
			 sscanf(line, "%[^\n]\n", value);
			 bookm[i]=g_strconcat (value,"\0",NULL);
			 i++;
			}
		 fclose (fp);
		}
	fullpath=g_strconcat (app->work_dir,"=",app->work_dir,"\0",NULL);
	 
	fp=fopen("/home/user/.deskypplet/ypplet-bookmarks.conf","w");
	if(fp!=NULL)
		{
		 for (j = 0; j < i; j++) 
			{
			 fprintf(fp,"%s\n",bookm[j]);
			}
		 fprintf(fp,"%s\n",fullpath);
		 fclose(fp);
		 hildon_banner_show_information(NULL, NULL, "Bookmark added to list");   
		}
	
	gtk_widget_destroy(app->table);
	create_table (app);
	
	return;
}

void play_folder (gchar *fullpath)
{
	/*printf ("play_folder FULLPATH %s\n",fullpath);*/
	char *basename;
	char *sou_file[500]={0};
	char *sou_chk={0};
	gchar *playlist_file;
	FILE *fp=NULL;
	int n_sou_files=0,i;
	
	if(chdir(playlist_dir)<0)
		{
		 g_print("Creating playlists directory\n");
		 /*printf("play_folder PLAYLIST_DIR %s\n",playlist_dir);*/
         if(mkdir(playlist_dir,(mode_t)0755) < 0)
			{
			 g_print("Error creating playlists directory\n");
			 }
		}
	else
		{
		 chdir ("/home/user/.deskypplet");
		}
		
	if((dir=opendir(fullpath)) == NULL) 
		{
		 fprintf(stderr,"Error opendir ...\n");
		 return ;
		}  
	while((dirpointer=readdir(dir)) != NULL)
		{ 
		 sou_file[n_sou_files]=g_strconcat ((*dirpointer).d_name,NULL);
		 sou_chk=g_strconcat (fullpath,"/",(*dirpointer).d_name,NULL);
		 /* printf("play_folder SOU_CHK %s\n",sou_chk);*/
		 if (strstr(sou_chk, ".mp3"))
			{
			 sou_file[n_sou_files]=g_strconcat (fullpath,"/",(*dirpointer).d_name,NULL);
			 n_sou_files++;
			}
		 else 
			{}
	    }
    qsort(sou_file, n_sou_files, sizeof sou_file[0],&myComparisonFunction);
 
    basename = strrchr(fullpath, '/') + 1;
    playlist_file=g_strconcat (playlist_dir,"/",basename,".m3u",NULL);
    
    fp=fopen(playlist_file,"w");
    if(fp!=NULL) 
		{
		 for (i = 0; i < n_sou_files; i++) 
			{
			 fprintf(fp,"%s\n",sou_file[i]);
			}
		 fclose(fp);
		}
	handle_mime (playlist_file);
	
	return;
}

gchar *g_get_capacity ( gchar * dev_path)
{
	unsigned long long result = 0;
	int n;
	gchar s_cap[50];
	gchar * ss_cap = "N/A";
	struct statvfs sfs;
	
	if ( statvfs ( dev_path, &sfs) != -1 )
		{
		 result = (unsigned long long)sfs.f_bsize * sfs.f_blocks;
		}
	if (result > 0)
		{
		 double f_cap = (double)result/(1024*1024*1024);
		 n = sprintf(s_cap, "%.3f Gb", f_cap);
		 ss_cap = g_strdup(s_cap);
		}
	
	return ss_cap;
}

gchar *g_get_free_space ( gchar * dev_path)
{
	unsigned long long result = 0;
	int n;
	gchar s_cap[50];
	gchar * ss_cap = "N/A";
	struct statvfs sfs;
	
	if ( statvfs ( dev_path, &sfs) != -1 )
		{
		 result = (unsigned long long)sfs.f_bsize * sfs.f_bfree;
		}
	if (result > 0)
		{
		 double f_cap = (double)result/(1024*1024*1024);
		 n = sprintf(s_cap, "%.3f Gb", f_cap);
		 ss_cap = g_strdup(s_cap);
		}
	
	return ss_cap;
}

void open_file (gpointer button,gchar *fullpath)
{
	/*printf ("open_file FULLPATH %s\n",fullpath);*/
	gtk_widget_destroy(dialog);
	handle_mime (fullpath);
	
	return;
}

void handle_mime (gchar *fullpath)
{
	/*printf ("handle_mime FULLPATH %s\n",fullpath);*/
	char var [100],value[100],line[200];
	char *mime_type [100];
	char delims[] = "@";
	gchar *com_do1=NULL;
	gchar *com_do2=NULL;
	gchar *file_open;
	int retval,i;
	GdkPixbuf *pixbuf=NULL; 
	DBusConnection *dbus = NULL;
	osso_context_t *osso;
	
	gchar *file_open_lastapp=g_strconcat (last_app_standing, " ",fullpath," &","\0",NULL);
	
	if (picviewer==1)
		{
		 if ((pixbuf= gdk_pixbuf_new_from_file_at_size(fullpath,800,420,NULL))!=0)
			{
			 pic_view (pixbuf);
			 return;
			}
		}
	   	     
	FILE *fp=fopen("/home/user/.deskypplet/mimehandling.conf","r");
    i=0;
    if (fp) 
		{
	 	 while (fgets(line,sizeof(line),fp))
			{
			 i++;    
             memset (var,0,sizeof(var));
             memset (value,0,sizeof(value));
		     sscanf(line,"%[^'=']=%[^\'#'\n]%*[\t]%*[\t]",var,value);  
             mime_type [i]=g_strconcat (var,NULL);
		     
		     if(strstr(fullpath,mime_type[i]))
				{
				 com_do1=strtok( value, delims );
				 com_do2=strtok( NULL, delims );
				 file_open=g_strconcat (com_do1,fullpath,com_do2,"\0",NULL);
			     system (file_open);
			     gtk_widget_destroy(app->table);
				 create_table (app);
				 return;
				}
			 /*printf("handle_mime FILE_OPEN %s",file_open)
			 printf ("handle_mime mime VAR %s\n",var);
			 printf ("handle_mime com VALUE %s\n",value);*/
			}
		 fclose (fp);
	    }
	  				   
		osso = osso_initialize("osso-mime-summon", "0.1", TRUE, NULL);
		if (osso == NULL) 
			{
			 printf("Failed to initialize libosso\n");
			 }
		dbus = (DBusConnection *) osso_get_dbus_connection(osso);
		if (dbus == NULL) 
			{
			 printf("Failed to get dbus connection from osso context\n");
			}
		retval = hildon_mime_open_file(dbus, fullpath);
		if (retval != 1) 
			{
			 printf("Failed to launch hildon_mime_open_file: %d\n", retval);
			 system (file_open_lastapp);
			}
	
	return;	     
}

void toggle_mp3_play (void)
{
	if (mp3_default==1)
		{
		 mp3_default=0;
		 mp3_play_status="Autoplay is off";
		 hildon_banner_show_information(NULL, NULL, "mp3 autoplay is now off");
		}
	else
		{
		 mp3_default=1;
		 mp3_play_status="Autoplay is on";
	     hildon_banner_show_information(NULL, NULL, "mp3 autoplay is now on");
		}
    
    gtk_widget_destroy(dialog);
	
	return;     
}

void toggle_bookmark_view (GObject *o,GdkEventButton *event,YNCtx *app)
{
	if (bookmarkview==0)
		{
		 gtk_widget_destroy(app->table);
		 show_bookmarks (app);
		 bookmarkview=1;
		}
	else
		{
		 bookmarkview=0;
		 gtk_widget_destroy(app->table);
		 create_table (app);
		}
    
    return;     
}

void toggle_exec_sh (void)
{
	if (sh_exec_default==1)
		{
		 sh_exec_default=0;
		 sh_exec_status="sh execute is off";
		 hildon_banner_show_information(NULL, NULL, "sh execute is now off");
		}
	else
		{
		 sh_exec_default=1;
		 sh_exec_status="sh execute is on";
	     hildon_banner_show_information(NULL, NULL, "sh execute is now on");
		}
    
    gtk_widget_destroy(dialog);
	
	return;     
}

void toggle_picviewer (void)
{
	if (picviewer==1)
		{
		 picviewer=0;
		 picviewer_status="Pic-viewer deactivated";
		 hildon_banner_show_information(NULL, NULL, "Pic-viewer deactivated");
		}
	else
		{
		 picviewer=1;
		 picviewer_status="Pic-viewer activated";
	     hildon_banner_show_information(NULL, NULL, "Pic-viewer activated");
		}
    
    gtk_widget_destroy(dialog);
	
	return;     
}

void toggle_mode (void)
{
	if (fast_mode==1)
		{
		 fast_mode=0;
		 mode_status="Advanced Mode is on";
		 hildon_banner_show_information(NULL, NULL, "Switched to Advanced Mode");
		}
	else
		{
		 fast_mode=1;
		 mode_status="Fast Mode is on";
		 hildon_banner_show_information(NULL, NULL, "Switched to Fast Mode");
		}
    
    gtk_widget_destroy(dialog);
    gtk_widget_destroy(app->table);
	create_table (app);
   	
	return;     
}

void show_bookmarks (YNCtx *app)
{
	GdkPixbuf *pixbuf=NULL; 
	gchar *dirpeg=NULL;
	gchar *dirpeg2=NULL;
	gchar *dirpeg3=NULL;
	gchar *dirpeg4=NULL;
	FILE *file;
	gchar *fullpath=0;
	char var [100],value[100],line[200];
	int i=1,j=0;
	int table_rows;
	GtkWidget *label=NULL;
	GtkWidget *table_label_evbx;
    GtkWidget *table_file_evbx;
    GtkWidget *table_file_img;
    GtkWidget *book_label=NULL;
	GtkWidget *book_label_evbx;
    GtkWidget *book_file_evbx;
    GtkWidget *book_file_img;
	PangoFontDescription *font_desc = pango_font_description_from_string (app->bookmarks_name_size); 
    GtkJustification textjustify = GTK_JUSTIFY_CENTER;
	
	table_rows=(app->applet_x_size/100)-1;
	app->table = gtk_table_new (table_rows,table_rows, FALSE);
    gtk_table_set_row_spacings (GTK_TABLE (app->table), 3);
    gtk_table_set_col_spacings (GTK_TABLE (app->table), 3);   
	
	book_file_evbx=gtk_event_box_new ();
	book_label_evbx=gtk_event_box_new ();
	book_file_img=gtk_image_new_from_file("/home/user/.deskypplet/icons/book_folder.png");
    book_label=gtk_label_new ("Add Folder to Bookmarks");
    gtk_widget_set_size_request (GTK_WIDGET(book_label),app->icon_label_x_size,app->icon_label_y_size);
    gtk_widget_modify_font (GTK_WIDGET(book_label), font_desc);
    gtk_label_set_justify (GTK_LABEL (book_label),textjustify);
    gtk_label_set_line_wrap (GTK_LABEL (book_label),TRUE);
    gtk_label_set_line_wrap_mode (GTK_LABEL (book_label), PANGO_WRAP_WORD_CHAR);
    gtk_misc_set_alignment(GTK_MISC(book_label), 0.5f, 0.0f);      
	gtk_event_box_set_visible_window(GTK_EVENT_BOX(book_file_evbx),FALSE);
	gtk_event_box_set_visible_window(GTK_EVENT_BOX(book_label_evbx),FALSE);
	g_signal_connect(G_OBJECT(book_file_evbx),"button_release_event", G_CALLBACK(book_this),NULL);
	gtk_container_add (GTK_CONTAINER (book_file_evbx),book_file_img);
	gtk_container_add (GTK_CONTAINER (book_label_evbx),book_label);
	 
	gtk_table_attach_defaults (GTK_TABLE (app->table), book_file_evbx,1,2,0,1);
    gtk_table_attach_defaults (GTK_TABLE (app->table), book_label_evbx,1,2,1,2);
		   
	FILE *fp=fopen("/home/user/.deskypplet/ypplet-bookmarks.conf","r");
	if (fp) 
		{
		 while (fgets(line,sizeof(line),fp))
			{
			 memset (var,0,sizeof(var));
			 memset (value,0,sizeof(value));
			 sscanf(line,"%[^'=']=%[^\'#'\n]%*[\t]%*[\t]",var,value);  
			 table_file_evbx=gtk_event_box_new ();
			 table_label_evbx=gtk_event_box_new ();
			 i++;if (i>table_rows) {i=1;j=j+2;}
			 dirpeg=g_strconcat (value,"/folder.jpg",NULL);
			 dirpeg2=g_strconcat (value,"/",value,".jpg",NULL);
			 dirpeg3=g_strconcat (value,"/folder.png",NULL);
			 dirpeg4=g_strconcat (value,"/cover.jpg",NULL);
           
			 file = fopen(dirpeg, "r");
			 if (file)  
				{
				 fclose(file);
				 pixbuf= gdk_pixbuf_new_from_file_at_size (dirpeg,app->icon_x_size,app->icon_y_size,NULL);   
				 table_file_img=gtk_image_new_from_pixbuf(pixbuf);
				}   
			 else 
				{ 
				 file = fopen(dirpeg2, "r");
				 if (file)  
					{
					 fclose(file);
					 pixbuf= gdk_pixbuf_new_from_file_at_size (dirpeg2,app->icon_x_size,app->icon_y_size,NULL);   
					 table_file_img=gtk_image_new_from_pixbuf(pixbuf);
					}
				 else 
					{ 
					 file = fopen(dirpeg3, "r");
					 if (file)  
						{
						 fclose(file);
						 pixbuf= gdk_pixbuf_new_from_file_at_size (dirpeg3,app->icon_x_size,app->icon_y_size,NULL);   
						 table_file_img=gtk_image_new_from_pixbuf(pixbuf);
						}   
					 else  
						{ 
						 file = fopen(dirpeg4, "r");
						 if (file)  
							{
							 fclose(file);
							 pixbuf= gdk_pixbuf_new_from_file_at_size (dirpeg4,app->icon_x_size,app->icon_y_size,NULL);   
							 table_file_img=gtk_image_new_from_pixbuf(pixbuf);
							}   
						 else  
							{
							 pixbuf=gdk_pixbuf_new_from_file_at_size("/home/user/.deskypplet/icons/folderbookmark.png",
							                                        app->icon_x_size,app->icon_y_size,NULL);
							 table_file_img=gtk_image_new_from_pixbuf(pixbuf);
							}
						}
					}
				}
			 fullpath=g_strconcat (value,"\0",NULL); 
			 gtk_container_add (GTK_CONTAINER (table_file_evbx),table_file_img);
			 if (fullpath==NULL)
				{
				 fullpath="/home/user";
				 }
			 label=gtk_label_new (var);
			 gtk_widget_set_size_request (GTK_WIDGET(label),app->icon_label_x_size,app->icon_label_y_size);
			 gtk_widget_modify_font (GTK_WIDGET(label), font_desc);
			 gtk_label_set_justify (GTK_LABEL (label),textjustify);
			 gtk_label_set_line_wrap (GTK_LABEL (label),TRUE);
			 gtk_label_set_line_wrap_mode (GTK_LABEL (label), PANGO_WRAP_WORD_CHAR);
		     gtk_misc_set_alignment(GTK_MISC(label), 0.5f, 0.0f);
			
			 gtk_widget_set_size_request (GTK_WIDGET(table_label_evbx),app->icon_label_x_size,app->icon_label_y_size);
			 gtk_widget_set_size_request (GTK_WIDGET(table_file_img),app->icon_x_size,app->icon_y_size);
         
			 g_signal_connect(G_OBJECT(table_file_evbx),"button_release_event", G_CALLBACK(bookmark_tapped),fullpath);
	
			 gtk_event_box_set_visible_window(GTK_EVENT_BOX(table_file_evbx),FALSE);
			 gtk_event_box_set_visible_window(GTK_EVENT_BOX(table_label_evbx),FALSE);
			 gtk_container_add (GTK_CONTAINER (table_label_evbx),label);
			 gtk_table_attach_defaults (GTK_TABLE (app->table), table_file_evbx,i,i+1,j,j+1);
			 gtk_table_attach_defaults (GTK_TABLE (app->table), table_label_evbx,i,i+1,j+1,j+2);
			 fullpath=g_strconcat (value,"\0",NULL);
			}
        fclose (fp);
	   }
	   
	  
	g_signal_connect (app->table, "expose-event", G_CALLBACK (handle_expose),app->table);
     
   	gtk_widget_set_size_request (GTK_WIDGET(app->label_evbox),app->applet_x_size-160,app->title_height);
    gtk_label_set_text (GTK_LABEL (app->path_label),app->work_dir);
   	 
    gtk_scrolled_window_add_with_viewport (GTK_SCROLLED_WINDOW (app->scrolledwindow_fb), app->table);
   	gtk_widget_show_all (GTK_WIDGET (app->frame));
   	pango_font_description_free (font_desc);
   	  
	return;
}

void call_help (void)
{
	gchar *helpfile="/home/user/.deskypplet/help/index.html";
	handle_mime (helpfile);
	gtk_widget_destroy(dialog);
	
	return;     
}

void check_config (void)
{
	return;
}

void menu_folders (gchar *fullpath)
{
	/*printf ("fullpath menu_folders %s\n",fullpath);*/
	gchar *com_com=NULL;
	gchar *com_do1=NULL;
	gchar *com_do2=NULL;
	gchar *title;
	char delims[] = "@";
	char var [100],value[100],line[200];
	int i=0;
	GtkWidget *vbox=NULL;
	GtkWidget *hbox=NULL;
	GtkWidget *button=NULL;
	/*GtkWidget *button_term=NULL;*/
	GtkWidget *button_t_mp3=NULL;
	GtkWidget *button_t_md=NULL;
	GtkWidget *button_chfol=NULL;
	GtkWidget *button_help=NULL;
	GtkWidget *pannable_area=NULL;
    GtkWidget *table=NULL;
	
	title=g_strconcat (fullpath,"\0",NULL);
	
	dialog=gtk_dialog_new_with_buttons(title,NULL, 0,0,0,0,0,NULL);
	gtk_widget_set_size_request (GTK_WIDGET(dialog),-1,800); 
    
    hbox=gtk_hbox_new(TRUE,0);
	vbox=gtk_vbox_new(TRUE,0);
	
	pannable_area = hildon_pannable_area_new ();
	
	table = gtk_table_new (40,2, FALSE);
    gtk_table_set_row_spacings (GTK_TABLE (table), 2);
    gtk_table_set_col_spacings (GTK_TABLE (table), 2);
   
	FILE *fp=fopen("/home/user/.deskypplet/folderactions.conf","r");
	if (fp) 
      {
	   while (fgets(line,sizeof(line),fp))
          {
	       i++;
	        sscanf(line,"%[^'=']=%[^\'#'\n]%*[\t]%*[\t]",var,value);  
		    
		  com_do1=strtok( value, delims );
          com_do2=strtok( NULL, delims );
          com_com=g_strconcat (com_do1,fullpath,com_do2,"\0",NULL);
		   /*printf ("menu_folders VAR %s\n",var);
			 printf ("menu_folders VALUE %s\n",value);
			 printf ("menu_folders COM_DO1 %s\n",com_do1);
			 printf ("menu_folders COM_DO2 %s\n",com_do2);*/
		   button = hildon_button_new_with_text (HILDON_SIZE_AUTO_WIDTH | HILDON_SIZE_FINGER_HEIGHT,
			    			       HILDON_BUTTON_ARRANGEMENT_VERTICAL, var,0);
	       g_signal_connect (button, "clicked", G_CALLBACK (custom_com),com_com);
           gtk_button_set_alignment (GTK_BUTTON(button),0,0.5);				       
	  
           gtk_table_attach_defaults (GTK_TABLE (table), button,1,2,i,i+1);
           }
	   fclose (fp);
	   }
	
	/*button_term = hildon_button_new_with_text (HILDON_SIZE_AUTO_WIDTH | HILDON_SIZE_FINGER_HEIGHT,
	                				       HILDON_BUTTON_ARRANGEMENT_VERTICAL,"Terminal here",NULL);
	g_signal_connect (button_term, "clicked", G_CALLBACK (term_her),NULL);
    gtk_button_set_alignment (GTK_BUTTON(button_term),0,0.5);				       
	gtk_table_attach_defaults (GTK_TABLE (table), button_term,2,3,2,3);*/  
	
	button_t_mp3 = hildon_button_new_with_text (HILDON_SIZE_AUTO_WIDTH | HILDON_SIZE_FINGER_HEIGHT,
	                				       HILDON_BUTTON_ARRANGEMENT_VERTICAL,"Play Folder",NULL);
	g_signal_connect (button_t_mp3, "clicked", G_CALLBACK (play_folder),fullpath);
    gtk_button_set_alignment (GTK_BUTTON(button_t_mp3),0,0.5);				       
	gtk_table_attach_defaults (GTK_TABLE (table), button_t_mp3,2,3,2,3);  
	
	button_chfol = hildon_button_new_with_text (HILDON_SIZE_AUTO_WIDTH | HILDON_SIZE_FINGER_HEIGHT,
	                				       HILDON_BUTTON_ARRANGEMENT_VERTICAL,"Open Folder",NULL);
	g_signal_connect (button_chfol, "clicked", G_CALLBACK (change_folder2),fullpath);
    gtk_button_set_alignment (GTK_BUTTON(button_chfol),0,0.5);				       
	gtk_table_attach_defaults (GTK_TABLE (table), button_chfol,2,3,1,2);  
	
	button_t_md = hildon_button_new_with_text (HILDON_SIZE_AUTO_WIDTH | HILDON_SIZE_FINGER_HEIGHT,
	                				       HILDON_BUTTON_ARRANGEMENT_VERTICAL,mode_status,NULL);
	g_signal_connect (button_t_md, "clicked", G_CALLBACK (toggle_mode),NULL);
    gtk_button_set_alignment (GTK_BUTTON(button_t_md),0,0.5);				       
	gtk_table_attach_defaults (GTK_TABLE (table), button_t_md,2,3,4,5);  
	
	button_help = hildon_button_new_with_text (HILDON_SIZE_AUTO_WIDTH | HILDON_SIZE_FINGER_HEIGHT,
	                				       HILDON_BUTTON_ARRANGEMENT_VERTICAL,"help",NULL);
	g_signal_connect (button_help, "clicked", G_CALLBACK (call_help),NULL);
    gtk_button_set_alignment (GTK_BUTTON(button_help),0,0.5);				       
	gtk_table_attach_defaults (GTK_TABLE (table), button_help,2,3,3,4);  
	
	hildon_pannable_area_add_with_viewport (HILDON_PANNABLE_AREA (pannable_area),table);
    gtk_container_add (GTK_CONTAINER (hbox), pannable_area);    
    gtk_container_add (GTK_CONTAINER (GTK_DIALOG(dialog)->vbox),hbox);
	gtk_widget_show_all(dialog);
	gtk_dialog_run (GTK_DIALOG(dialog));
	
	return;
}

void menu_files (gchar *fullpath)
{
	/*printf ("menu_files FULLPATH %s\n",fullpath);*/
	gchar *com_com=NULL;
	gchar *com_do1=NULL;
	gchar *com_do2=NULL;
	gchar *title;
	char delims[] = "@";
	char var [100],value[100],line[200];
	int i=0;
	GtkWidget *vbox=NULL;
	GtkWidget *hbox=NULL;
	GtkWidget *button=NULL;
	/*GtkWidget *button_t_sh=NULL;*/
	GtkWidget *button_op_fl=NULL;
	GtkWidget *button_t_md=NULL;
	GtkWidget *button_help=NULL;
	GtkWidget *pannable_area=NULL;
    GtkWidget *table=NULL;
	
	title=g_strconcat (fullpath,"\0",NULL);
	
	dialog=gtk_dialog_new_with_buttons(title,NULL, 0,0,0,0,0,NULL);
	gtk_widget_set_size_request (GTK_WIDGET(dialog),-1,800); 
    
    hbox=gtk_hbox_new(TRUE,0);
	vbox=gtk_vbox_new(TRUE,0);
	
	pannable_area = hildon_pannable_area_new ();
	table = gtk_table_new (40,2, FALSE);
    gtk_table_set_row_spacings (GTK_TABLE (table), 2);
    gtk_table_set_col_spacings (GTK_TABLE (table), 2);
    
  
	FILE *fp=fopen("/home/user/.deskypplet/fileactions.conf","r");
	if (fp) 
		{
		 while (fgets(line,sizeof(line),fp))
			{
			 i++;
			 sscanf(line,"%[^'=']=%[^\'#'\n]%*[\t]%*[\t]",var,value);  
		     com_do1=strtok( value, delims );
			 com_do2=strtok( NULL, delims );
			 com_com=g_strconcat (com_do1,fullpath,com_do2,"\0",NULL);
			 /*printf ("menu_files VAR %s\n",var);
			 printf ("menu_files VALUE %s\n",value);
			 printf ("menu_files COM_DO1 %s\n",com_do1);
			 printf ("menu_files COM_DO2 %s\n",com_do2);*/
			 button = hildon_button_new_with_text (HILDON_SIZE_AUTO_WIDTH | HILDON_SIZE_FINGER_HEIGHT,
			    			       HILDON_BUTTON_ARRANGEMENT_VERTICAL, var,0);
			 g_signal_connect (button, "clicked", G_CALLBACK (custom_com),com_com);
			 gtk_button_set_alignment (GTK_BUTTON(button),0,0.5);				       
	         gtk_table_attach_defaults (GTK_TABLE (table), button,1,2,i,i+1);
			}
		 fclose (fp);
		}
	
	button_op_fl = hildon_button_new_with_text (HILDON_SIZE_AUTO_WIDTH | HILDON_SIZE_FINGER_HEIGHT,
	                				       HILDON_BUTTON_ARRANGEMENT_VERTICAL,"Open File",NULL);
	g_signal_connect (button_op_fl, "clicked", G_CALLBACK (open_file),fullpath);
    gtk_button_set_alignment (GTK_BUTTON(button_op_fl),0,0.5);				       
	gtk_table_attach_defaults (GTK_TABLE (table), button_op_fl,2,3,1,2);  
	   
	/*button_t_sh = hildon_button_new_with_text (HILDON_SIZE_AUTO_WIDTH | HILDON_SIZE_FINGER_HEIGHT,
	                				       HILDON_BUTTON_ARRANGEMENT_VERTICAL,sh_exec_status,NULL);
	g_signal_connect (button_t_sh, "clicked", G_CALLBACK (toggle_exec_sh),NULL);
    gtk_button_set_alignment (GTK_BUTTON(button_t_sh),0,0.5);				       
	gtk_table_attach_defaults (GTK_TABLE (table), button_t_sh,2,3,2,3);*/  
	
	button_t_md = hildon_button_new_with_text (HILDON_SIZE_AUTO_WIDTH | HILDON_SIZE_FINGER_HEIGHT,
	                				       HILDON_BUTTON_ARRANGEMENT_VERTICAL,mode_status,NULL);
	g_signal_connect (button_t_md, "clicked", G_CALLBACK (toggle_mode),NULL);
    gtk_button_set_alignment (GTK_BUTTON(button_t_md),0,0.5);				       
	gtk_table_attach_defaults (GTK_TABLE (table), button_t_md,2,3,3,4);  
	
	button_help = hildon_button_new_with_text (HILDON_SIZE_AUTO_WIDTH | HILDON_SIZE_FINGER_HEIGHT,
	                				       HILDON_BUTTON_ARRANGEMENT_VERTICAL,"help",NULL);
	g_signal_connect (button_help, "clicked", G_CALLBACK (call_help),NULL);
    gtk_button_set_alignment (GTK_BUTTON(button_help),0,0.5);				       
	gtk_table_attach_defaults (GTK_TABLE (table), button_help,2,3,2,3);  
	
	hildon_pannable_area_add_with_viewport (HILDON_PANNABLE_AREA (pannable_area),table);
    gtk_container_add (GTK_CONTAINER (hbox), pannable_area);
    gtk_container_add (GTK_CONTAINER (GTK_DIALOG(dialog)->vbox),hbox);
	gtk_widget_show_all(dialog);
	gtk_dialog_run (GTK_DIALOG(dialog));
	
	return;
}

void pic_view(GdkPixbuf *pixbuf)
{
	GtkWidget *evbox;
	GtkWidget *image;
	
	gtk_widget_destroy(dialog);
	win = gtk_window_new (GTK_WINDOW_TOPLEVEL);
    gtk_widget_realize (win);
    image=gtk_image_new_from_pixbuf(pixbuf);
    evbox=gtk_event_box_new ();
	gtk_event_box_set_visible_window(GTK_EVENT_BOX(evbox),FALSE);
	gtk_container_add (GTK_CONTAINER (evbox),image);
	gtk_container_add (GTK_CONTAINER (win), evbox);
    g_signal_connect(G_OBJECT(evbox),"button_release_event",G_CALLBACK(end_picview),NULL);
    gtk_window_set_decorated (GTK_WINDOW (win),FALSE);
    gtk_window_fullscreen (GTK_WINDOW (win));
    gtk_widget_show_all (win);
 
	return ;
}

void end_picview(void)
{
	gtk_widget_destroy(win);
	return ;
}

/*
NEW
use internal picture viewer=1
fat finger modus
last app standing
TXT .txt icons bug
execute bit set?  use noext-exe.png instead?
 
TO DO
support for .desktop files
show hide hidden
*/

