#!/bin/sh

fnCheckName()
{
if [ -d "$1" ]
 then
  run-standalone.sh dbus-send --type=method_call --dest=org.freedesktop.Notifications /org/freedesktop/Notifications org.freedesktop.Notifications.SystemNoteInfoprint string:"Directory Created$extra"
 else
  run-standalone.sh dbus-send --type=method_call --dest=org.freedesktop.Notifications /org/freedesktop/Notifications org.freedesktop.Notifications.SystemNoteInfoprint string:"Warning: Failed to create directory"
 fi
}

#--------------------------------------------------------- Main Code

name=$( zenity --title="Create Directory" --text="Directoryname:" --entry ) || exit

case $1 in
 /home/user*)
    mkdir $1/$name
    ;;
 /media/*)
    mkdir $1/$name
    ;;
 /*)
    mkdir $1/$name
    if [ ! -d "$1/$name" ]
        then
        zenity --title="Creation failed" --text="Want to create it as ROOT?" --question || exit
	sudo mkdir $1/$name
	extra=" as ROOT"
        fi
    ;;
 esac
fnCheckName $1/$name
