#include "tabledlg.h"
#include "ui_tabledlg.h"

#include <QSqlDatabase>
#include <QSqlTableModel>

TableDlg::TableDlg(QString tableName, QWidget *parent) :
    QDialog(parent),
    ui(new Ui::TableDlg)
{
    ui->setupUi(this);

    m_pModel = new QSqlTableModel(this, QSqlDatabase::database());
    m_pModel->setTable(tableName);
    m_pModel->setEditStrategy(QSqlTableModel::OnManualSubmit);
    m_pModel->select();

    // datatablemodel_lastsort = -1;

    ui->tableView->setModel(m_pModel);
    ui->tableView->resizeColumnsToContents();
    ui->tableView->resizeRowsToContents();

    setWindowTitle(tableName);
}

TableDlg::~TableDlg() {
    delete ui;
}

void TableDlg::changeEvent(QEvent *e)
{
    QDialog::changeEvent(e);
    switch (e->type()) {
    case QEvent::LanguageChange:
        ui->retranslateUi(this);
        break;
    default:
        break;
    }
}
