#include "querydlg.h"
#include "ui_querydlg.h"

#include <QSqlDatabase>
#include <QSqlError>
#include <QSqlQuery>

#include <QDebug>
#include <QMessageBox>

#include "SQLHighlighter.h"

#ifdef Q_WS_MAEMO_5
    #include <QMaemo5InformationBox>
#endif

QueryDlg::QueryDlg(QWidget *parent) :
    QDialog(parent),
    ui(new Ui::QueryDlg)
{
    ui->setupUi(this);

    // configure query editor
#ifdef Q_WS_MAEMO_5
    QFont font("Courier");
    ui->sqlEdit->setInputMethodHints(Qt::ImhNoAutoUppercase);
    ui->splitter->setSizes(QList<int>() << 150 << 330 );
#else
    QFont font("Courier", 10);
#endif

    font.setFixedPitch(true);
    ui->sqlEdit->setFont(font);

    new SQLHighlighter(ui->sqlEdit->document());

    connect(ui->sqlEdit, SIGNAL(runQuery()), SLOT(onRunQuery()));
}

QueryDlg::~QueryDlg()
{
    delete ui;
}

void QueryDlg::changeEvent(QEvent *e) {
    QDialog::changeEvent(e);
    switch (e->type()) {
    case QEvent::LanguageChange:
        ui->retranslateUi(this);
        break;
    default:
        break;
    }
}

void QueryDlg::onRunQuery() {
    m_query.setQuery(ui->sqlEdit->toPlainText(), QSqlDatabase::database());
    if (m_query.lastError().isValid()) {
        qDebug() << m_query.lastError();

#ifdef Q_WS_MAEMO_5
        QMaemo5InformationBox::information(this,
            m_query.lastError().text(),
            5000
        );
#else
        QMessageBox::warning(this, "SQL Error", m_query.lastError().text());
#endif

        ui->tableView->setModel(NULL);
        return;
    }

    if ( m_query.query().isSelect() ) {
        // select
        ui->tableView->setModel(&m_query);
        ui->tableView->resizeColumnsToContents();
        ui->tableView->resizeRowsToContents();
        return;
    }

    // not select
    ui->tableView->setModel(NULL);

#ifdef Q_WS_MAEMO_5
        QMaemo5InformationBox::information(this,
            "SQL Executed successfully",
            3000
        );
#endif
}
