#ifndef OPENFILEDLG_H
#define OPENFILEDLG_H

#include <QDialog>
#include <QModelIndex>
#include <QDir>

namespace Ui {
    class OpenFileDlg;
}

class OpenFileDlg : public QDialog
{
    Q_OBJECT

public:
    explicit OpenFileDlg(QString path, QWidget *parent = 0);
    ~OpenFileDlg();

    virtual int exec();
    QString filename();

protected:
    virtual void setPath(QString path);
    virtual bool skip(QFileInfo fileInfo);

protected:
    void changeEvent(QEvent *e);

protected:
    QString m_filename;
    Ui::OpenFileDlg *ui;
    QDir m_currentDir;


private slots:
    void on_listWidget_clicked(QModelIndex index);
    void on_lineEdit_returnPressed();
    void on_listWidget_doubleClicked(QModelIndex index);
};

#endif // OPENFILEDLG_H
