#include "openfiledlg.h"
#include "ui_openfiledlg.h"

#include <QDir>
#include <QFile>
#include <QDebug>
#include <QMessageBox>

OpenFileDlg::OpenFileDlg(QString path, QWidget *parent) :
    QDialog(parent),
    ui(new Ui::OpenFileDlg)
{
    ui->setupUi(this);

    m_currentDir = QDir(path);
}

OpenFileDlg::~OpenFileDlg()
{
    delete ui;
}

void OpenFileDlg::changeEvent(QEvent *e)
{
    QDialog::changeEvent(e);
    switch (e->type()) {
    case QEvent::LanguageChange:
        ui->retranslateUi(this);
        break;
    default:
        break;
    }
}

void OpenFileDlg::on_lineEdit_returnPressed() {
    setPath(ui->lineEdit->text());
}

int OpenFileDlg::exec() {
    if ( m_currentDir.exists()) setPath(m_currentDir.absolutePath());
    return QDialog::exec();
}

QString OpenFileDlg::filename() {
    return m_filename;
}

bool OpenFileDlg::skip(QFileInfo fileInfo) {
    // show all
    return false;
}

void OpenFileDlg::setPath(QString path) {
    qDebug() << "select Folder: " << path;

    ui->listWidget->clear();

    QDir newDir(path);
    if ( !newDir.exists() ) {
        QMessageBox::warning(this, "Invalid folder", path);
        qDebug() << "Directory does not exist: " << path;
        return;
    }

    m_currentDir = newDir;
    ui->lineEdit->setText(m_currentDir.absolutePath());

    ui->listWidget->addItem("[..]");

    foreach (QString filename,
        m_currentDir.entryList(
            QDir::Dirs|QDir::Files|QDir::NoDotAndDotDot|QDir::Readable|QDir::Hidden,
            QDir::DirsLast|QDir::Name
        )
    ) {
        QFileInfo info(m_currentDir, filename);
        if ( skip(info) ) continue;

        if ( info.isDir() ) {
            ui->listWidget->addItem(QString("[%1]").arg(filename));
            continue;
        }

        ui->listWidget->addItem(filename);
    }

}

void OpenFileDlg::on_listWidget_clicked(QModelIndex index){
    QString text = ui->listWidget->item(index.row())->text();
    if ( text=="[..]" ) {
        if ( m_currentDir.cdUp() ) setPath(m_currentDir.absolutePath());
        return;
    }

    if ( text.startsWith('[') ) {
        text = text.mid(1, text.length()-2);
        setPath(m_currentDir.absolutePath() + QDir::separator() + text);
        return;
    }

    m_filename = m_currentDir.absolutePath() + QDir::separator() + text;
    accept();
}

void OpenFileDlg::on_listWidget_doubleClicked(QModelIndex index) {
}
