#ifndef MAINWINDOW_H
#define MAINWINDOW_H

#include <QMainWindow>
#include <QSqlDatabase>
#include <QModelIndex>

class DatabaseDlg;

namespace Ui {
    class MainWindow;
}

class MainWindow : public QMainWindow
{
    Q_OBJECT

public:
    explicit MainWindow(QWidget *parent = 0);
    ~MainWindow();

private:
    void loadSettings();
    bool openDatabase(QString filename);

protected:
    void changeEvent(QEvent *e);

private:
    Ui::MainWindow *ui;

    QSqlDatabase    m_db;
    DatabaseDlg     *m_pDatabaseDlg;

private slots:
    void on_listWidget_clicked(QModelIndex index);
    void on_listWidget_doubleClicked(QModelIndex index);
    void on_openDatabaseAction_triggered();
    void on_newDatabaseAction_triggered();
};

#endif // MAINWINDOW_H
