#ifndef YOUTUBEVIDEOLISTWINDOW_H
#define YOUTUBEVIDEOLISTWINDOW_H

#include "stackedwindow.h"
#include "../base/videoitem.h"

class YouTubeVideoListModel;
class ListView;
class QAction;
class QLabel;
class QModelIndex;

class YouTubeVideoListWindow : public StackedWindow
{
    Q_OBJECT

public:
    explicit YouTubeVideoListWindow(QWidget *parent);
    void setVideoFeed(const QUrl &feed);
    void search(const QString &query,
                Queries::QueryOrder order,
                Queries::TimeFilter time,
                Queries::DurationFilter duration,
                const QString &language);

protected:
    void showEvent(QShowEvent *event);

private:
    void setLandscapeLayout();
    void setPortraitLayout();

private slots:
    void setMenuActions();
    void onLoadingChanged(bool loading);
    void onCountChanged(int count);
    void deleteVideosFromUploads();
    void addVideosToFavourites();
    void deleteVideosFromFavourites();
    void addVideosToPlaylist();
    void addVideosToWatchLaterPlaylist();
    void deleteVideosFromWatchLaterPlaylist();
    void addVideoDownloads();
    void addAudioDownloads();
    void queueVideos();
    void showContextMenu(const QPoint &pos);
    void deleteVideoFromUploads();
    void addVideoToFavourites();
    void deleteVideoFromFavourites();
    void showPlaylistDialog();
    void addVideoToPlaylist(const QString &id);
    void addVideoToNewPlaylist(const QVariantMap &playlist);
    void addVideoToWatchLaterPlaylist();
    void deleteVideoFromWatchLaterPlaylist();
    void addVideoDownload();
    void addAudioDownload();
    void queueVideo();
    void onItemClicked(const QModelIndex &index);
    void showVideoInfo(QSharedPointer<VideoItem> video);
    void playVideo(const QModelIndex &index);

private:
    ListView *m_listView;
    YouTubeVideoListModel *m_model;
    QAction *m_deleteFromUploadsAction;
    QAction *m_deleteFromWatchLaterAction;
    QAction *m_addToFavouritesAction;
    QAction *m_deleteFromFavouritesAction;
    QAction *m_addToPlaylistAction;
    QAction *m_addToWatchLaterAction;
    QAction *m_addToQueueAction;
    QAction *m_videoDownloadAction;
    QAction *m_audioDownloadAction;
    QMenu *m_contextMenu;
    QAction *m_deleteFromUploadsContextAction;
    QAction *m_deleteFromWatchLaterContextAction;
    QAction *m_addToFavouritesContextAction;
    QAction *m_deleteFromFavouritesContextAction;
    QAction *m_addToPlaylistContextAction;
    QAction *m_addToWatchLaterContextAction;
    QAction *m_addToQueueContextAction;
    QAction *m_videoDownloadContextAction;
    QAction *m_audioDownloadContextAction;
    QLabel *m_noResultsLabel;
};

#endif // YOUTUBEVIDEOLISTWINDOW_H
