#ifndef UTILS_H
#define UTILS_H

#include "enums.h"
#include <QString>
#include <QDateTime>

#ifndef QML_USER_INTERFACE
class QPainter;
class QRect;
class QImage;
#endif

class Utils
{

public:
    static QString durationFromSecs(int secs);
    static QString durationFromMSecs(int msecs);
    static QString fileSizeFromPath(const QString &filePath);
    static QString fileSizeFromBytes(double bytes);
    static QString dateFromSecs(qint64 secs, bool showTime = true);
    static QString dateFromMSecs(qint64 msecs, bool showTime = true);
    static QString localDateTimeFromString(const QString &dateTimeString, Qt::DateFormat = Qt::ISODate);
    static QString base64Id(const QString &artist, const QString &title);
    static QString serviceString(Services::VideoService service);
    static QString unescape(const QString &s);
    static void log(const QString &filePath, const QByteArray &message);
    static QString versionNumberString();
#ifndef QML_USER_INTERFACE
    static void drawBorderImage(QPainter *painter, const QRect &rect, const QImage &image, int top, int right, int left, int bottom);
#endif
};

#endif // UTILS_H
