#ifndef DAILYMOTIONSUBSCRIPTIONLISTMODEL_H
#define DAILYMOTIONSUBSCRIPTIONLISTMODEL_H

#include "useritem.h"
#include <QAbstractListModel>
#include <QSharedPointer>

#ifndef QML_USER_INTERFACE
class ThumbnailCache;
#endif

class DailymotionSubscriptionListModel : public QAbstractListModel
{
    Q_OBJECT

    Q_PROPERTY(int count
               READ rowCount
               NOTIFY countChanged)

public:
    enum Roles {
        IdRole = Qt::UserRole + 1,
        SubscriptionIdRole,
        UsernameRole,
        ChannelNameRole,
#ifndef QML_USER_INTERFACE
        AvatarRole,
#endif
        AvatarUrlRole,
        VideoCountRole,
        DescriptionRole,
        ViewCountRole,
        SubscriberCountRole,
        SubscriptionRole
    };

public:
    explicit DailymotionSubscriptionListModel(QObject *parent = 0);
    ~DailymotionSubscriptionListModel();
#if QT_VERSION >= 0x050000
    QHash<int, QByteArray> roleNames() const;
#endif
    int rowCount(const QModelIndex &parent = QModelIndex()) const;
    QVariant data(const QModelIndex &index, int role = Qt::DisplayRole) const;
    Q_INVOKABLE QVariant data(int row, const QByteArray &role) const;
    QSharedPointer<UserItem> get(int row) const;
#ifdef QML_USER_INTERFACE
    Q_INVOKABLE UserItem* getFromQML(int row) const;
#endif

private slots:
    void onSubscriptionAdded(int row);
    void onSubscriptionRemoved(int row);
#ifndef QML_USER_INTERFACE
    void onThumbnailReady();
#endif

signals:
    void countChanged(int count);

private:
#ifndef QML_USER_INTERFACE
    ThumbnailCache *m_cache;
#endif
    QHash<int, QByteArray> m_roleNames;
};

#endif // DAILYMOTIONSUBSCRIPTIONLISTMODEL_H
