#ifndef YOUTUBEVIDEOCOMMENTSTAB_H
#define YOUTUBEVIDEOCOMMENTSTAB_H

#include "abstracttab.h"
#include "../base/videoitem.h"
#include "../base/commentitem.h"

class YouTubeCommentListModel;
class ListView;
class QMenu;
class QAction;
class QLabel;
class QGridLayout;
class QModelIndex;

class YouTubeVideoCommentsTab : public AbstractTab
{
    Q_OBJECT

public:
    explicit YouTubeVideoCommentsTab(QSharedPointer<VideoItem> video, QWidget *parent);

private:
    void setLandscapeLayout();
    void setPortraitLayout();

private slots:
    void onLoadingChanged(bool loading);
    void onCountChanged(int count);
    void showCommentDialog(QSharedPointer<CommentItem> initialComment = QSharedPointer<CommentItem>());
    void showContextMenu(const QPoint &pos);
    void replyToComment();
    void showUserChannel(const QModelIndex &index);
    
private:
    QSharedPointer<VideoItem> m_video;
    YouTubeCommentListModel *m_model;
    ListView *m_listView;
    QMenu *m_contextMenu;
    QAction *m_replyAction;
    QAction *m_commentAction;
    QLabel *m_noResultsLabel;
    QGridLayout *m_grid;
};

#endif // YOUTUBEVIDEOCOMMENTSTAB_H
