#include "vimeousergrouplistmodel.h"
#include "vimeo.h"
#ifndef QML_USER_INTERFACE
#include "thumbnailcache.h"
#endif

VimeoUserGroupListModel::VimeoUserGroupListModel(QObject *parent) :
    QAbstractListModel(parent)
  #ifndef QML_USER_INTERFACE
    ,m_cache(new ThumbnailCache)
  #endif
{
    QHash<int, QByteArray> roles;
    roles[IdRole] = "id";
    roles[TitleRole] = "title";
    roles[ArtistRole] = "artist";
    roles[DateRole] = "date";
    roles[VideoCountRole] = "videoCount";
#ifndef QML_USER_INTERFACE
    roles[ThumbnailRole] = "thumbnail";
#endif
    roles[ThumbnailUrlRole] = "thumbnailUrl";
    roles[DescriptionRole] = "description";
    this->setRoleNames(roles);
#ifndef QML_USER_INTERFACE
    this->connect(m_cache, SIGNAL(thumbnailReady()), this, SLOT(onThumbnailReady()));
#endif
    if (!Vimeo::instance()->groupsLoaded()) {
        Vimeo::instance()->getGroups();
    }

    this->connect(Vimeo::instance(), SIGNAL(groupAddedToCache(int)), this, SLOT(onGroupAdded(int)));
    this->connect(Vimeo::instance(), SIGNAL(groupRemovedFromCache(int)), this, SLOT(onGroupRemoved(int)));
}

VimeoUserGroupListModel::~VimeoUserGroupListModel() {
#ifndef QML_USER_INTERFACE
    delete m_cache;
    m_cache = 0;
#endif
}

void VimeoUserGroupListModel::onGroupAdded(int row) {
    this->beginInsertRows(QModelIndex(), row, row);
    this->endInsertRows();
    emit countChanged(this->rowCount());
}

void VimeoUserGroupListModel::onGroupRemoved(int row) {
    this->beginRemoveRows(QModelIndex(), row, row);
    this->endRemoveRows();
    emit countChanged(this->rowCount());
}

int VimeoUserGroupListModel::rowCount(const QModelIndex &parent) const {
    Q_UNUSED(parent)

    return Vimeo::instance()->groups()->size();
}

QVariant VimeoUserGroupListModel::data(const QModelIndex &index, int role) const {
    switch (role) {
    case IdRole:
        return Vimeo::instance()->groups()->at(index.row()).data()->id();
    case TitleRole:
        return Vimeo::instance()->groups()->at(index.row()).data()->title();
    case ArtistRole:
        return Vimeo::instance()->groups()->at(index.row()).data()->artist();
    case DateRole:
        return Vimeo::instance()->groups()->at(index.row()).data()->date();
    case VideoCountRole:
        return Vimeo::instance()->groups()->at(index.row()).data()->videoCount();
#ifndef QML_USER_INTERFACE
    case ThumbnailRole:
        return m_cache->thumbnail(Vimeo::instance()->groups()->at(index.row()).data()->thumbnailUrl(), QSize(120, 90));
#endif
    case ThumbnailUrlRole:
        return Vimeo::instance()->groups()->at(index.row()).data()->thumbnailUrl();
    case DescriptionRole:
        return Vimeo::instance()->groups()->at(index.row()).data()->description();
    default:
        return QVariant();
    }
}

QVariant VimeoUserGroupListModel::data(int row, const QByteArray &role) const {
    return this->data(this->index(row), this->roleNames().key(role));
}

QSharedPointer<GroupItem> VimeoUserGroupListModel::get(int row) const {
    return QSharedPointer<GroupItem>(Vimeo::instance()->groups()->at(row));
}

#ifdef QML_USER_INTERFACE
GroupItem* VimeoUserGroupListModel::getFromQML(int row) const {
    return Vimeo::instance()->groups()->at(row).data();
}
#endif

#ifndef QML_USER_INTERFACE
void VimeoUserGroupListModel::onThumbnailReady() {
    emit dataChanged(this->index(0), this->index(this->rowCount() - 1));
}
#endif
