#ifndef SESSION_H
#define SESSION_H

#include <QObject>

class CookieJar;
class Settings;
class Database;
class VideoLauncher;
class PlaybackListModel;
class YouTube;
class Dailymotion;
class Vimeo;
class Sharing;
class UrlGrabber;
class Notifications;
class TransferManager;
class ClipboardMonitor;
class QNetworkAccessManager;
#ifdef GRABBER_PLUGIN
class PluginManager;
#endif
#ifndef QML_USER_INTERFACE
class ThumbnailCache;
#ifdef Q_WS_MAEMO_5
class WindowStack;
#endif
#endif

class Session : public QObject
{
    Q_OBJECT

public:
    explicit Session(QObject *parent = 0);
    ~Session();
    inline QNetworkAccessManager* networkAccessManager() const { return m_nam; }
    static Session* instance();

private slots:
    void onMediaPlayerChanged(const QString &player);
    
private:
    QNetworkAccessManager *m_nam;
    CookieJar *m_jar;
    Settings *m_settings;
    Database *m_database;
    VideoLauncher *m_launcher;
    PlaybackListModel *m_queue;
    YouTube *m_youtube;
    Dailymotion *m_dailymotion;
    Vimeo *m_vimeo;
    Sharing *m_sharing;
    UrlGrabber *m_grabber;
#ifdef GRABBER_PLUGIN
    PluginManager *m_pluginManager;
#endif
    Notifications *m_notifications;
    TransferManager *m_transferManager;
    ClipboardMonitor *m_monitor;
#ifndef QML_USER_INTERFACE
    ThumbnailCache *m_cache;
#ifdef Q_WS_MAEMO_5
    WindowStack *m_stack;
#endif
#endif
};

#endif // SESSION_H
