#ifndef DAILYMOTIONUSERGROUPLISTTAB_H
#define DAILYMOTIONUSERGROUPLISTTAB_H

#include "abstracttab.h"
#include "../base/groupitem.h"

class ListView;
class DailymotionUserGroupListModel;
class QLabel;
class QMenu;
class QAction;
class QGridLayout;
class QModelIndex;

class DailymotionUserGroupListTab : public AbstractTab
{
    Q_OBJECT
public:
    explicit DailymotionUserGroupListTab(QWidget *parent = 0);

private:
    void setLandscapeLayout();
    void setPortraitLayout();

private slots:
    void onGroupsLoaded();
    void onCountChanged(int count);
    void onItemClicked(const QModelIndex &index);
    void showGroup(QSharedPointer<GroupItem> group);
    void showContextMenu(const QPoint &pos);
    void leaveGroup();

private:
    ListView *m_listView;
    DailymotionUserGroupListModel *m_model;
    QMenu *m_contextMenu;
    QAction *m_leaveAction;
    QLabel *m_noResultsLabel;
    QGridLayout *m_grid;
};

#endif // DAILYMOTIONUSERGROUPLISTTAB_H
