#ifndef ABSTRACTCOMMENTLISTMODEL_H
#define ABSTRACTCOMMENTLISTMODEL_H

#include "commentitem.h"
#include <QAbstractListModel>
#include <QSharedPointer>

#ifndef QML_USER_INTERFACE
class ThumbnailCache;
#endif

class AbstractCommentListModel : public QAbstractListModel
{
    Q_OBJECT

public:
    enum Roles {
        IdRole = Qt::UserRole + 1,
        BodyRole,
        ArtistRole,
        ArtistIdRole,
        ArtistAvatarUrlRole,
        DateRole,
        VideoIdRole,
        ReplyIdRole,
        IndentRole,
        LoadingRole
#ifndef QML_USER_INTERFACE
        ,ArtistAvatarRole,
        AvatarPressedRole,
        LoaderPressedRole
#endif
    };

public:
    explicit AbstractCommentListModel(QObject *parent = 0);
    ~AbstractCommentListModel();
    int rowCount(const QModelIndex &parent = QModelIndex()) const;
    QVariant data(const QModelIndex &index, int role) const;
    Q_INVOKABLE QVariant data(int row, const QByteArray &role) const;
#ifndef QML_USER_INTERFACE
    bool setData(const QModelIndex &index, const QVariant &value, int role);
#endif
    QSharedPointer<CommentItem> get(int row) const;
#ifdef QML_USER_INTERFACE
    Q_INVOKABLE CommentItem* getFromQML(int row) const;
#endif

public slots:
    void clear();
    void insertComment(int row, QSharedPointer<CommentItem> comment);
    void appendComment(QSharedPointer<CommentItem> comment);
    bool removeComment(const QVariant &value, int role = IdRole);
    
protected:
    bool removeRow(int row, const QModelIndex &parent = QModelIndex());

#ifndef QML_USER_INTERFACE
protected slots:
    void onThumbnailReady();
#endif

protected:
#ifndef QML_USER_INTERFACE
    ThumbnailCache *m_cache;
    int m_avatarPressedRow;
    int m_loaderPressedRow;
#endif
    QList< QSharedPointer<CommentItem> > m_list;
};

#endif // ABSTRACTCOMMENTLISTMODEL_H
