TEMPLATE = app
QT += network sql xml
TARGET = cutetube

INSTALLS += target

SOURCES = $$files(src/base/*.cpp)
HEADERS = $$files(src/base/*.h)

maemo5 {
    DEFINES += CUTETUBE_PLAYER_ENABLED
    QT += maemo5 dbus webkit
    CONFIG += mobility12
    MOBILITY += multimedia
    SOURCES += $$files(src/maemo5_gui/*.cpp)
    HEADERS += $$files(src/maemo5_gui/*.h)
    RESOURCES = src/maemo5_gui/resources.qrc

    desktopfile.path = /usr/share/applications/hildon
    desktopfile.files = desktop/maemo5/cutetube.desktop

    icon.path = /usr/share/icons/hicolor/64x64/apps
    icon.files = desktop/cutetube64.png

    translations.files += $$files(src/maemo5_gui/translations/*.*)
    translations.path += /opt/cutetube/translations

    dbus_service.files += dbus/maemo5/com.maemo.cuteTube.service
    dbus_service.path = /usr/share/dbus-1/services
    dbus_interface.files += dbus/maemo5/com.maemo.cuteTube.xml
    dbus_interface.path = /usr/share/dbus-1/interfaces

    target.path = /opt/cutetube/bin

    INSTALLS += translations desktopfile icon dbus_service dbus_interface
}

symbian {
    QT += declarative
    DEFINES += QML_USER_INTERFACE SYMBIAN_OS GRABBER_PLUGIN
    MMP_RULES += "DEBUGGABLE_UDEBONLY"
    TARGET = cutetube_0x20068c69
    CONFIG += qt-components mobility
    MOBILITY += gallery sysinfo
    TARGET.EPOCHEAPSIZE = 0x20000 0x8000000
    TARGET.EPOCSTACKSIZE = 0x14000
    TARGET.CAPABILITY += NetworkServices ReadUserData
    TARGET.UID3 = 0xE561674E //0x20068c69
    DEPLOYMENT.display_name = cuteTube
    VERSION = 1.8.2
    ICON = desktop/cutetube.svg

    my_deployment.pkg_prerules += vendorinfo

    DEPLOYMENT += my_deployment

    vendorinfo += "%{\"Stuart Howarth\"}" ":\"Stuart Howarth\""

    folder_01.source = qml/symbian
    folder_01.target = qml
    DEPLOYMENTFOLDERS = folder_01

    SOURCES += $$files(src/symbian/*.cpp) \
        $$files(src/qml/*.cpp) \
        $$files(src/plugins/*.cpp)
    HEADERS += $$files(src/symbian/*.h) \
        $$files(src/qml/*.h) \
        $$files(src/plugins/*.h)
    RESOURCES = qml/symbian/resources.qrc
}

contains(MEEGO_EDITION,harmattan) {
    DEFINES += QML_USER_INTERFACE CUTETUBE_PLAYER_ENABLED GRABBER_PLUGIN
    QT+= opengl dbus declarative
    CONFIG += qdeclarative-boostable \
        libtuiclient \
        libcontentaction \
        shareuiinterface-maemo-meegotouch \
        share-ui-plugin \
        share-ui-common \
        mdatauri \
        mobility \
        qmsystem2

    MOBILITY += gallery
    SOURCES += $$files(src/harmattan/*.cpp) \
        $$files(src/qml/*.cpp) \
        $$files(src/plugins/*.cpp)
    HEADERS += $$files(src/harmattan/*.h) \
        $$files(src/qml/*.h) \
        $$files(src/plugins/*.h)
    RESOURCES = qml/harmattan/resources.qrc

    folder_01.source = qml/harmattan
    folder_01.target = qml
    DEPLOYMENTFOLDERS = folder_01

    desktop_file.path = /usr/share/applications
    desktop_file.files = desktop/harmattan/cutetube.desktop

    icon80.path = /usr/share/icons/hicolor/80x80/apps
    icon80.files = desktop/cutetube80.png

    icon64.path = /usr/share/icons/hicolor/64x64/apps
    icon64.files = desktop/cutetube64.png

    dbus_service.files = dbus/harmattan/com.maemo.cuteTube.service
    dbus_service.path = /usr/share/dbus-1/services
    dbus_interface.files = dbus/harmattan/com.maemo.cuteTube.xml
    dbus_interface.path = /usr/share/dbus-1/interfaces

    contentaction.files = contentaction/cutetube.xml
    contentaction.path = /usr/share/contentaction

    target.path = /opt/cutetube/bin

    resources.files += $$files(resources/*.*)
    resources.path = /opt/cutetube/resources

    launcher.files = desktop/harmattan/launcher.sh
    launcher.path = /opt/cutetube/bin

    INSTALLS += target desktop_file icon80 icon64 dbus_service dbus_interface contentaction resources launcher
}

simulator {
    QT += declarative
    DEFINES += SYMBIAN_OS QML_USER_INTERFACE
    CONFIG += qt-components mobility
    MOBILITY += gallery sysinfo

    folder_01.source = qml/symbian
    folder_01.target = qml
    DEPLOYMENTFOLDERS = folder_01

    SOURCES += $$files(src/symbian/*.cpp) \
        $$files(src/qml/*.cpp)
    HEADERS += $$files(src/symbian/*.h) \
        $$files(src/qml/*.h)
    RESOURCES = qml/symbian/resources.qrc
}
