#include "dailymotionsubscriptionstab.h"
#include "dailymotionuserlistdelegate.h"
#include "dailymotionchannelwindow.h"
#include "dailymotionvideolistwindow.h"
#include "../base/dailymotionsubscriptionlistmodel.h"
#include "../base/dailymotion.h"
#include "../base/notifications.h"
#include "../base/windowstack.h"
#include "listview.h"
#include <QMenu>
#include <QAction>
#include <QLabel>
#include <QGridLayout>
#include <QMaemo5Style>

DailymotionSubscriptionsTab::DailymotionSubscriptionsTab(QWidget *parent) :
    AbstractTab(parent),
    m_model(new DailymotionSubscriptionListModel(this)),
    m_listView(new ListView(this)),
    m_contextMenu(new QMenu(this)),
    m_unsubscribeAction(m_contextMenu->addAction(tr("Unsubscribe"), this, SLOT(unsubscribe()))),
    m_videosAction(new QAction(tr("Latest videos"), this)),
    m_noResultsLabel(new QLabel(QString("<p style='color:%1;font-size:40px;'><center><b>%2</b></center></p>").arg(QMaemo5Style::standardColor("SecondaryTextColor").name()).arg(tr("No subscriptions found")), this)),
    m_grid(new QGridLayout(this))
{
    this->addAction(m_videosAction);

    m_grid->setContentsMargins(0, 0, 0, 0);
    m_grid->addWidget(m_listView, 0, 0);
    m_listView->setItemDelegate(new DailymotionUserListDelegate(m_listView));
    m_noResultsLabel->hide();

    if (Dailymotion::instance()->subscriptionsLoaded()) {
        this->onSubscriptionsLoaded();
    }
    else {
        Notifications::toggleBusy(true);
        this->connect(Dailymotion::instance(), SIGNAL(allSubscriptionsLoaded()), this, SLOT(onSubscriptionsLoaded()));
    }

    this->connect(m_model, SIGNAL(countChanged(int)), this, SLOT(onCountChanged(int)));
    this->connect(m_videosAction, SIGNAL(triggered()), this, SLOT(showSubscriptionVideos()));

    this->onOrientationChanged();
}

void DailymotionSubscriptionsTab::setLandscapeLayout() {
    m_noResultsLabel->setFixedSize(800, 400);
}

void DailymotionSubscriptionsTab::setPortraitLayout() {
    m_noResultsLabel->setFixedSize(480, 700);
}

void DailymotionSubscriptionsTab::onSubscriptionsLoaded() {
    Notifications::toggleBusy(false);
    m_listView->setModel(m_model);
    m_noResultsLabel->setVisible(m_model->rowCount() == 0);

    this->connect(m_listView, SIGNAL(clicked(QModelIndex)), this, SLOT(onItemClicked(QModelIndex)));
    this->connect(m_listView, SIGNAL(customContextMenuRequested(QPoint)), this, SLOT(showContextMenu(QPoint)));
}

void DailymotionSubscriptionsTab::onCountChanged(int count) {
    m_noResultsLabel->setVisible(count == 0);
}

void DailymotionSubscriptionsTab::onItemClicked(const QModelIndex &index) {
    if (index.isValid()) {
        this->showUserChannel(index.data(DailymotionSubscriptionListModel::IdRole).toString());
    }
}

void DailymotionSubscriptionsTab::showUserChannel(const QString &userId) {
    DailymotionChannelWindow *window = new DailymotionChannelWindow(userId, WindowStack::instance()->currentWindow());
    window->show();
}

void DailymotionSubscriptionsTab::showSubscriptionVideos() {
    DailymotionVideoListWindow *window = new DailymotionVideoListWindow(WindowStack::instance()->currentWindow());
    window->setWindowTitle(tr("Latest subscription videos"));
    window->setVideoFeed(DAILYMOTION_NEW_SUBSCRIPTION_VIDEOS_FEED);
    window->show();
}

void DailymotionSubscriptionsTab::showContextMenu(const QPoint &pos) {
    m_contextMenu->popup(pos, m_unsubscribeAction);
}

void DailymotionSubscriptionsTab::unsubscribe() {
    Dailymotion::instance()->unsubscribe(m_model->data(m_listView->currentIndex(), DailymotionSubscriptionListModel::IdRole).toString());
}
