#include "twitterauthdialog.h"
#include "../base/sharing.h"
#include "webview.h"
#include <QProgressBar>
#include <QGridLayout>

TwitterAuthDialog::TwitterAuthDialog(QWidget *parent) :
    AbstractDialog(parent),
    m_webView(new WebView(this)),
    m_progressBar(new QProgressBar(this)),
    m_grid(new QGridLayout(this))
{
    this->setWindowTitle(tr("twitter authorisation"));

    m_grid->addWidget(m_webView, 0, 0);
    m_grid->addWidget(m_progressBar, 1, 0);

    m_webView->enableSelectionSuppressor();
    m_progressBar->setTextVisible(false);

    this->connect(Sharing::instance(), SIGNAL(gotTwitterAuthUrl(QUrl)), this, SLOT(setAuthUrl(QUrl)));
    this->connect(m_webView, SIGNAL(loadProgress(int)), m_progressBar, SLOT(setValue(int)));
    this->connect(m_webView, SIGNAL(loadStarted()), m_progressBar, SLOT(show()));
    this->connect(m_webView, SIGNAL(loadFinished(bool)), m_progressBar, SLOT(hide()));
    this->connect(this, SIGNAL(rejected()), Sharing::instance(), SLOT(cancelTwitterSignIn()));

    Sharing::instance()->getTwitterAuthUrl();

    this->onOrientationChanged();
}

void TwitterAuthDialog::setAuthUrl(const QUrl &url) {
    m_webView->setUrl(url);
    this->connect(m_webView, SIGNAL(urlChanged(QUrl)), this, SLOT(checkUrlForToken(QUrl)));
}

void TwitterAuthDialog::checkUrlForToken(const QUrl &url) {
    if (url.toString().startsWith("https://sites.google.com/site/marxodian/home/cutetube")) {
        Sharing::instance()->signInToTwitter(url);
        this->accept();
    }
}
