#include "vimeouseralbumlisttab.h"
#include "vimeoalbumlistdelegate.h"
#include "vimeonewalbumdialog.h"
#include "vimeoalbumvideoswindow.h"
#include "listview.h"
#include "../base/vimeouseralbumlistmodel.h"
#include "../base/vimeo.h"
#include "../base/notifications.h"
#include "../base/windowstack.h"
#include <QLabel>
#include <QMenu>
#include <QAction>
#include <QGridLayout>

VimeoUserAlbumListTab::VimeoUserAlbumListTab(QWidget *parent) :
    AbstractTab(parent),
    m_listView(new ListView(this)),
    m_model(new VimeoUserAlbumListModel(this)),
    m_contextMenu(new QMenu(this)),
    m_deleteAction(m_contextMenu->addAction(tr("Delete"), this, SLOT(deleteAlbum()))),
    m_newAlbumAction(new QAction(tr("New album"), this)),
    m_noResultsLabel(new QLabel(QString("<p style='color:#4d4d4d;font-size:40px;'><center><b>%1</b></center></p>").arg(tr("No albums found")), this)),
    m_grid(new QGridLayout(this))
{
    this->addAction(m_newAlbumAction);

    m_grid->setContentsMargins(0, 0, 0, 0);
    m_grid->addWidget(m_listView, 0, 0);
    m_listView->setItemDelegate(new VimeoAlbumListDelegate(m_listView));
    m_noResultsLabel->hide();

    if (Vimeo::instance()->albumsLoaded()) {
        this->onAlbumsLoaded();
    }
    else {
        Notifications::toggleBusy(true);
        this->connect(Vimeo::instance(), SIGNAL(allAlbumsLoaded()), this, SLOT(onAlbumsLoaded()));
    }

    this->connect(m_model, SIGNAL(countChanged(int)), this, SLOT(onCountChanged(int)));
    this->connect(m_newAlbumAction, SIGNAL(triggered()), this, SLOT(showNewAlbumDialog()));

    this->onOrientationChanged();
}

void VimeoUserAlbumListTab::setLandscapeLayout() {
    m_noResultsLabel->setFixedSize(800, 400);
}

void VimeoUserAlbumListTab::setPortraitLayout() {
    m_noResultsLabel->setFixedSize(480, 700);
}

void VimeoUserAlbumListTab::onAlbumsLoaded() {
    Notifications::toggleBusy(false);
    m_noResultsLabel->setVisible(m_model->rowCount() == 0);
    m_listView->setModel(m_model);

    this->connect(m_listView, SIGNAL(clicked(QModelIndex)), this, SLOT(onItemClicked(QModelIndex)));
    this->connect(m_listView, SIGNAL(customContextMenuRequested(QPoint)), this, SLOT(showContextMenu(QPoint)));
}

void VimeoUserAlbumListTab::onCountChanged(int count) {
    m_noResultsLabel->setVisible(count == 0);
}

void VimeoUserAlbumListTab::onItemClicked(const QModelIndex &index) {
    if (index.isValid()) {
        this->showAlbum(m_model->get(index.row()));
    }
}

void VimeoUserAlbumListTab::showAlbum(QSharedPointer<PlaylistItem> album) {
    VimeoAlbumVideosWindow *window = new VimeoAlbumVideosWindow(album, WindowStack::instance()->currentWindow());
    window->show();
}

void VimeoUserAlbumListTab::showContextMenu(const QPoint &pos) {
    m_contextMenu->popup(pos, m_deleteAction);
}

void VimeoUserAlbumListTab::deleteAlbum() {
    Vimeo::instance()->deleteAlbum(m_listView->currentIndex().data(VimeoUserAlbumListModel::AlbumIdRole).toString());
}

void VimeoUserAlbumListTab::showNewAlbumDialog() {
    VimeoNewAlbumDialog *dialog = new VimeoNewAlbumDialog(this);
    dialog->open();

    this->connect(dialog, SIGNAL(albumCreated(QVariantMap)), Vimeo::instance(), SLOT(createAlbum(QVariantMap)));
}
