#include "transfermovedelegate.h"
#include "../base/transferlistmodel.h"
#include <QPainter>

TransferMoveDelegate::TransferMoveDelegate(QObject *parent) :
    QStyledItemDelegate(parent)
{
}

void TransferMoveDelegate::paint(QPainter *painter, const QStyleOptionViewItem &option, const QModelIndex &index) const {
    if ((option.state) & (QStyle::State_Selected)) {
        painter->drawImage(option.rect, QImage("/etc/hildon/theme/images/TouchListBackgroundPressed.png"));
    }
    else {
        painter->drawImage(option.rect, QImage("/etc/hildon/theme/images/TouchListBackgroundNormal.png"));
    }

    QRect indexRect = option.rect;
    indexRect.moveLeft(indexRect.left() + 5);
    indexRect.setWidth(40);

    painter->drawText(indexRect, Qt::AlignCenter, QString::number(index.row() + 1));

    QRect textRect = option.rect;
    textRect.setLeft(textRect.left() + 50);
    textRect.setRight(textRect.right() - 5);

    painter->drawText(textRect, Qt::AlignVCenter, index.data(TransferListModel::TitleRole).toString());
}

QSize TransferMoveDelegate::sizeHint(const QStyleOptionViewItem &option, const QModelIndex &index) const {
    Q_UNUSED(index);

    return QSize(option.rect.width(), 80);
}
