#ifndef DAILYMOTIONVIDEODESCRIPTIONTAB_H
#define DAILYMOTIONVIDEODESCRIPTIONTAB_H

#include "abstracttab.h"
#include "../base/videoitem.h"

class ThumbnailLabel;
class RatingIndicator;
class QAction;
class QLabel;
class QScrollArea;
class QGridLayout;

class DailymotionVideoDescriptionTab : public AbstractTab
{
    Q_OBJECT

public:
    explicit DailymotionVideoDescriptionTab(QSharedPointer<VideoItem> video, QWidget *parent);

private:
    void setLandscapeLayout();
    void setPortraitLayout();
    void setMenuActions();
    QString tagsToString(QStringList tags);

private slots:
    void showEditMetadataDialog();
    void toggleFavourite();
    void onFavouriteChanged(bool favourite);
    void showPlaylistDialog();
    void addVideoToPlaylist(const QString &id);
    void addVideoToNewPlaylist(const QVariantMap &playlist);
    void addVideoToPlaybackQueue();
    void addVideoDownload();
    void addAudioDownload();
    void playVideo();
    void setThumbnails();
    void showShareDialog();
    void shareVideo(Services::SharingService service);
    void showFacebookDialog();
    void showTwitterDialog();
    void search(const QString &query);
    void showUserChannel();

private:
    QSharedPointer<VideoItem> m_video;
    QAction *m_editAction;
    QAction *m_favouritesAction;
    QAction *m_addToPlaylistAction;
    QAction *m_queueAction;
    QAction *m_videoDownloadAction;
    QAction *m_audioDownloadAction;
    QAction *m_shareAction;
    ThumbnailLabel *m_thumbnail;
    ThumbnailLabel *m_avatar;
    RatingIndicator *m_ratingIndicator;
    QLabel *m_titleLabel;
    QLabel *m_dateLabel;
    QLabel *m_viewsLabel;
    QLabel *m_descriptionLabel;
    QLabel *m_tagsLabel;
    QScrollArea *m_scrollArea;
    QGridLayout *m_grid;
};

#endif // DAILYMOTIONVIDEODESCRIPTIONTAB_H
