#ifndef YOUTUBEUSERPLAYLISTLISTMODEL_H
#define YOUTUBEUSERPLAYLISTLISTMODEL_H

#include "playlistitem.h"
#include <QAbstractListModel>
#include <QSharedPointer>

#ifndef QML_USER_INTERFACE
class ThumbnailCache;
#endif

class YouTubeUserPlaylistListModel : public QAbstractListModel
{
    Q_OBJECT

    Q_PROPERTY(int count
               READ rowCount
               NOTIFY countChanged)

public:
    enum Roles {
        IdRole = Qt::UserRole + 1,
        PlaylistIdRole,
        TitleRole,
        ArtistRole,
        DateRole,
        VideoCountRole,
#ifndef QML_USER_INTERFACE
        ThumbnailRole,
#endif
        ThumbnailUrlRole,
        DescriptionRole
    };

public:
    explicit YouTubeUserPlaylistListModel(QObject *parent = 0);
    ~YouTubeUserPlaylistListModel();
    int rowCount(const QModelIndex &parent = QModelIndex()) const;
    QVariant data(const QModelIndex &index, int role = Qt::DisplayRole) const;
    Q_INVOKABLE QVariant data(int row, const QByteArray &role) const;
    QSharedPointer<PlaylistItem> get(int row) const;
#ifdef QML_USER_INTERFACE
    Q_INVOKABLE PlaylistItem* getFromQML(int row) const;
#endif

private slots:
    void onPlaylistAdded(int row);
    void onPlaylistRemoved(int row);
    void onPlaylistUpdated(int row);
#ifndef QML_USER_INTERFACE
    void onThumbnailReady();
#endif

signals:
    void countChanged(int count);

#ifndef QML_USER_INTERFACE
private:
    ThumbnailCache *m_cache;
#endif
};

#endif // YOUTUBEUSERPLAYLISTLISTMODEL_H
