#include "youtubesubscriptionlistmodel.h"
#include "youtube.h"
#ifndef QML_USER_INTERFACE
#include "thumbnailcache.h"
#endif

YouTubeSubscriptionListModel::YouTubeSubscriptionListModel(QObject *parent) :
    QAbstractListModel(parent)
  #ifndef QML_USER_INTERFACE
    ,m_cache(new ThumbnailCache)
  #endif
{
    QHash<int, QByteArray> roles;
    roles[IdRole] = "id";
    roles[SubscriptionIdRole] = "subscriptionId";
    roles[UsernameRole] = "username";
    roles[ChannelNameRole] = "channelName";
#ifndef QML_USER_INTERFACE
    roles[AvatarRole] = "avatar";
#endif
    roles[AvatarUrlRole] = "avatarUrl";
    roles[VideoCountRole] = "videoCount";
    roles[DescriptionRole] = "description";
    roles[ViewCountRole] = "viewCount";
    roles[SubscriberCountRole] = "subscriberCount";
    roles[SubscriptionRole] = "subscription";
    this->setRoleNames(roles);
#ifndef QML_USER_INTERFACE
    this->connect(m_cache, SIGNAL(thumbnailReady()), this, SLOT(onThumbnailReady()));
#endif
    if (!YouTube::instance()->subscriptionsLoaded()) {
        YouTube::instance()->getSubscriptions();
    }

    this->connect(YouTube::instance(), SIGNAL(subscriptionAddedToCache(int)), this, SLOT(onSubscriptionAdded(int)));
    this->connect(YouTube::instance(), SIGNAL(subscriptionRemovedFromCache(int)), this, SLOT(onSubscriptionRemoved(int)));
}

YouTubeSubscriptionListModel::~YouTubeSubscriptionListModel() {
#ifndef QML_USER_INTERFACE
    delete m_cache;
    m_cache = 0;
#endif
}

void YouTubeSubscriptionListModel::onSubscriptionAdded(int row) {
    this->beginInsertRows(QModelIndex(), row, row);
    this->endInsertRows();
    emit countChanged(this->rowCount());
}

void YouTubeSubscriptionListModel::onSubscriptionRemoved(int row) {
    this->beginRemoveRows(QModelIndex(), row, row);
    this->endRemoveRows();
    emit countChanged(this->rowCount());
}

int YouTubeSubscriptionListModel::rowCount(const QModelIndex &parent) const {
    Q_UNUSED(parent)

    return YouTube::instance()->subscriptions()->size();
}

QVariant YouTubeSubscriptionListModel::data(const QModelIndex &index, int role) const {
    switch (role) {
    case IdRole:
        return YouTube::instance()->subscriptions()->at(index.row()).data()->id();
    case SubscriptionIdRole:
        return YouTube::instance()->subscriptions()->at(index.row()).data()->subscriptionId();
    case UsernameRole:
        return YouTube::instance()->subscriptions()->at(index.row()).data()->username();
    case ChannelNameRole:
        return YouTube::instance()->subscriptions()->at(index.row()).data()->channelName();
#ifndef QML_USER_INTERFACE
    case AvatarRole:
        return m_cache->thumbnail(YouTube::instance()->subscriptions()->at(index.row()).data()->avatarUrl(), QSize(60, 60));
#endif
    case AvatarUrlRole:
        return YouTube::instance()->subscriptions()->at(index.row()).data()->avatarUrl();
    case VideoCountRole:
        return YouTube::instance()->subscriptions()->at(index.row()).data()->videoCount();
    case SubscriberCountRole:
        return YouTube::instance()->subscriptions()->at(index.row()).data()->subscriberCount();
    case SubscriptionRole:
        return YouTube::instance()->subscriptions()->at(index.row()).data()->subscription();
    default:
        return QVariant();
    }
}

QVariant YouTubeSubscriptionListModel::data(int row, const QByteArray &role) const {
    return this->data(this->index(row), this->roleNames().key(role));
}

QSharedPointer<UserItem> YouTubeSubscriptionListModel::get(int row) const {
    return QSharedPointer<UserItem>(YouTube::instance()->subscriptions()->at(row));
}

#ifdef QML_USER_INTERFACE
UserItem* YouTubeSubscriptionListModel::getFromQML(int row) const {
    return YouTube::instance()->subscriptions()->at(row).data();
}
#endif

#ifndef QML_USER_INTERFACE
void YouTubeSubscriptionListModel::onThumbnailReady() {
    emit dataChanged(this->index(0), this->index(this->rowCount() - 1));
}
#endif
