#ifndef VIMEOVIDEOLISTMODEL_H
#define VIMEOVIDEOLISTMODEL_H

#include "abstractvideolistmodel.h"

class VimeoVideoListModel : public AbstractVideoListModel
{
    Q_OBJECT

    Q_PROPERTY(bool loading
               READ loading
               NOTIFY loadingChanged)
    Q_PROPERTY(int count
               READ rowCount
               NOTIFY countChanged)
    Q_PROPERTY(bool itemsSelected
               READ itemsSelected
               NOTIFY itemsSelectedChanged)
    Q_PROPERTY(QUrl feed
               READ feed
               WRITE setFeed
               NOTIFY feedChanged)
    Q_PROPERTY(bool refreshRequired
               READ refreshRequired
               NOTIFY refreshRequiredChanged)

public:
    explicit VimeoVideoListModel(QObject *parent = 0);
    inline QUrl feed() const { return m_feed; }
    void setFeed(const QUrl &feed);
    inline QString albumId() const { return m_albumId; }
    inline bool loading() const { return m_loading; }
    inline bool refreshRequired() const { return m_refresh; }

public slots:
    void clear();
    void reset();
    void getVideos(QUrl feed = QUrl());
    void getMoreVideos();
    void getGroupVideos(const QString &id);
    void getAlbumVideos(const QString &id);
    void search(const QString &query = QString(), int order = Queries::Relevance);
    void deleteSelectedVideosFromUploads();
    void addSelectedVideosToLikes();
    void deleteSelectedVideosFromLikes();
    void addSelectedVideosToAlbum(const QString &albumId);
    void addSelectedVideosToNewAlbum(const QVariantMap &album);
    void deleteSelectedVideosFromAlbum(const QString &albumId);
    void addSelectedVideosToWatchLaterAlbum();
    void deleteSelectedVideosFromWatchLaterAlbum();
    void downloadSelectedVideos(bool saveAsAudio = false);
    void queueSelectedVideos();
    inline void toggleSelected(int row) { AbstractVideoListModel::toggleSelected(row); emit itemsSelectedChanged(this->itemsSelected()); }
    inline void selectAll() { AbstractVideoListModel::selectAll(); emit itemsSelectedChanged(true); }
    inline void selectNone() { AbstractVideoListModel::selectNone(); emit itemsSelectedChanged(false); }

private slots:
    void addVideos();
    void onDeletedFromUploads(const QString &videoId);
    void onLikeChanged(const QString &videoId, bool like);
    void onAddedToWatchLaterAlbum(const QString &videoId);
    void onDeletedFromWatchLaterAlbum(const QString &videoId);
    void onAddedToAlbum(const QString &videoId, const QString &albumId);
    void onDeletedFromAlbum(const QString &videoId, const QString &albumId);
    inline void onError() { this->setError(true); this->setLoading(false); }
    inline void stopLoading() { this->setLoading(false); }

private:
    inline void setAlbumId(const QString &id) { m_albumId = id; }
    inline QString query() const { return m_query; }
    inline void setQuery(const QString &query) { m_query = query; }
    inline int order() const { return m_order; }
    inline void setOrder(int order) { m_order = order; }
    inline void setLoading(bool loading) { m_loading = loading; emit loadingChanged(loading); }
    inline bool moreResults() const { return m_moreResults; }
    inline void setMoreResults(bool more) { m_moreResults = more; }
    inline int offset() const { return m_offset; }
    inline void setOffset(int offset) { m_offset = offset; }
    inline bool error() const { return m_error; }
    inline void setError(bool error) { m_error = error; }
    inline void setRefreshRequired(bool refresh) { m_refresh = refresh; emit refreshRequiredChanged(refresh); }

signals:
    void loadingChanged(bool loading);
    void countChanged(int count);
    void itemsSelectedChanged(bool selected);
    void refreshRequiredChanged(bool refresh);
    void feedChanged(const QUrl &feed);

private:
    QUrl m_feed;
    QString m_albumId;
    QString m_query;
    int m_order;
    bool m_loading;
    bool m_moreResults;
    bool m_error;
    int m_offset;
    bool m_refresh;
};

#endif // VIMEOVIDEOLISTMODEL_H
