#ifndef SCREENSAVER_H
#define SCREENSAVER_H

#include <QObject>
#include <qplatformdefs.h>
#if defined (Q_WS_MAEMO_5)
#include <QWidget>
#include <X11/Xlib.h>
#include <X11/Xatom.h>
#include <QX11Info>
#elif defined (MEEGO_EDITION_HARMATTAN)
#include <QTimer>
#include <qmsystem2/qmdisplaystate.h>
#else
#include <qmobilityglobal.h>
#include <QSystemScreenSaver>

QTM_USE_NAMESPACE
#endif

class ScreenSaver : public QObject
{
    Q_OBJECT

public:
    explicit ScreenSaver(QObject *parent = 0);
#ifdef Q_WS_MAEMO_5
    static void preventBlanking(Window windowId, bool prevent = true);
#else
public slots:
    void preventBlanking(bool prevent = true);
#endif

#ifndef Q_WS_MAEMO_5
private:
#ifdef MEEGO_EDITION_HARMATTAN
    MeeGo::QmDisplayState m_displayState;
    QTimer m_timer;
#else
    QSystemScreenSaver m_screenSaver;
#endif
#endif
};

#endif // SCREENSAVER_H
