#include "screensaver.h"

ScreenSaver::ScreenSaver(QObject *parent) :
    QObject(parent)
{
#ifdef MEEGO_EDITION_HARMATTAN
    m_timer.setInterval(60000);
    this->connect(&m_timer, SIGNAL(timeout()), this, SLOT(preventBlanking()));
#endif
}

#ifdef Q_WS_MAEMO_5
void ScreenSaver::preventBlanking(Window windowId, bool prevent) {
    Atom atom = XInternAtom(QX11Info::display() , "_HILDON_DO_NOT_DISTURB", False);

    if (prevent) {
        long state = 1;
        XChangeProperty(
                    QX11Info::display(),
                    windowId,
                    atom,
                    XA_INTEGER,
                    32,
                    PropModeReplace,
                    (unsigned char *) &state,
                    1);
    }
    else {
        XDeleteProperty(QX11Info::display(), windowId, atom);
    }
}
#else
void ScreenSaver::preventBlanking(bool prevent) {
#ifdef MEEGO_EDITION_HARMATTAN
    if (prevent) {
        m_displayState.setBlankingPause();
        m_timer.start();
    }
    else {
        m_displayState.cancelBlankingPause();
        m_timer.stop();
    }
#else
    m_screenSaver.setScreenSaverInhibited(prevent);
#endif
}
#endif
