#ifndef YOUTUBESUBSCRIPTIONSTAB_H
#define YOUTUBESUBSCRIPTIONSTAB_H

#include "abstracttab.h"

class Session;
class YouTubeSubscriptionListModel;
class ListView;
class QMenu;
class QAction;
class QLabel;
class QGridLayout;
class QModelIndex;

class YouTubeSubscriptionsTab : public AbstractTab
{
    Q_OBJECT
public:
    explicit YouTubeSubscriptionsTab(Session *session, QWidget *parent = 0);

private:
    void setLandscapeLayout();
    void setPortraitLayout();

private slots:
    void onSubscriptionsLoaded();
    void onCountChanged(int count);
    void onItemClicked(const QModelIndex &index);
    void showContextMenu(const QPoint &pos);
    void unsubscribe();
    void showUserChannel(const QString &userId);
    void showSubscriptionVideos();
    
private:
    Session *m_session;
    YouTubeSubscriptionListModel *m_model;
    ListView *m_listView;
    QMenu *m_contextMenu;
    QAction *m_unsubscribeAction;
    QAction *m_videosAction;
    QLabel *m_noResultsLabel;
    QGridLayout *m_grid;
};

#endif // YOUTUBESUBSCRIPTIONSTAB_H
