#ifndef YOUTUBEPRIVATEAUTHDIALOG_H
#define YOUTUBEPRIVATEAUTHDIALOG_H

#include "abstractdialog.h"

class Session;
class CookieJar;
class WebView;
class QProgressBar;
class QGridLayout;
class QUrl;

class YouTubePrivateAuthDialog : public AbstractDialog
{
    Q_OBJECT

public:
    explicit YouTubePrivateAuthDialog(Session *session, QWidget *parent = 0);

private:
    inline void setLandscapeLayout() { this->setFixedHeight(340); }
    inline void setPortraitLayout() { this->setFixedHeight(600); }

private slots:
    void checkUrl(const QUrl &url);
    
private:
    CookieJar *m_jar;
    WebView *m_webView;
    QProgressBar *m_progressBar;
    QGridLayout *m_grid;
};

#endif // YOUTUBEPRIVATEAUTHDIALOG_H
