#include "vimeoauthdialog.h"
#include "../base/session.h"
#include "webview.h"
#include <QProgressBar>
#include <QGridLayout>

VimeoAuthDialog::VimeoAuthDialog(Session *session, const QString &accountName, QWidget *parent) :
    AbstractDialog(parent),
    m_session(session),
    m_name(accountName),
    m_webView(new WebView(this)),
    m_progressBar(new QProgressBar(this)),
    m_grid(new QGridLayout(this))
{
    this->setWindowTitle(tr("Vimeo authorisation"));

    m_grid->addWidget(m_webView, 0, 0);
    m_grid->addWidget(m_progressBar, 1, 0);

    m_webView->enableSelectionSuppressor();
    m_progressBar->setTextVisible(false);

    this->connect(m_session->vimeo(), SIGNAL(gotAuthUrl(QUrl)), this, SLOT(setAuthUrl(QUrl)));
    this->connect(m_webView, SIGNAL(loadProgress(int)), m_progressBar, SLOT(setValue(int)));
    this->connect(m_webView, SIGNAL(loadStarted()), m_progressBar, SLOT(show()));
    this->connect(m_webView, SIGNAL(loadFinished(bool)), m_progressBar, SLOT(hide()));

    m_session->vimeo()->getAuthUrl();

    this->onOrientationChanged();
}

void VimeoAuthDialog::setAuthUrl(const QUrl &url) {
    m_authUrl = url;
    m_webView->setUrl(url);
    this->connect(m_webView, SIGNAL(urlChanged(QUrl)), this, SLOT(checkUrlForToken(QUrl)));
}

void VimeoAuthDialog::checkUrlForToken(const QUrl &url) {
    if (url.toString() == "https://vimeo.com/home") {
        //Work-around as for some reason the re-direct is not working in Maemo5.
        m_webView->setUrl(m_authUrl);
    }
    if (url.toString().startsWith("https://sites.google.com/site/marxodian/home/cutetube")) {
        m_session->vimeo()->signIn(m_name, url);
        this->accept();
    }
    else if (url.toString() == "https://vimeo.com") {
        m_session->onInfo(tr("You have denied access to your Vimeo account"));
        this->reject();
    }
}
