#include "dailymotionprivateauthdialog.h"
#include "../base/session.h"
#include "webview.h"
#include <QProgressBar>
#include <QGridLayout>

static const QUrl loginUrl("http://www.dailymotion.com/pageitem/loginfull?mode=basic&request=/login?request=%2F");

DailymotionPrivateAuthDialog::DailymotionPrivateAuthDialog(Session *session, QWidget *parent) :
    AbstractDialog(parent),
    m_jar(session->cookieJar()),
    m_webView(new WebView(this)),
    m_progressBar(new QProgressBar(this)),
    m_grid(new QGridLayout(this))
{
    this->setWindowTitle(tr("Dailymotion authorisation"));

    m_grid->addWidget(m_webView, 0, 0);
    m_grid->addWidget(m_progressBar, 1, 0);

    m_webView->setNetworkAccessManager(session->networkAccessManager());
    m_webView->setUrl(loginUrl);
    m_webView->enableSelectionSuppressor();
    m_progressBar->setTextVisible(false);

    this->connect(m_webView, SIGNAL(urlChanged(QUrl)), this, SLOT(checkUrl(QUrl)));
    this->connect(m_webView, SIGNAL(loadProgress(int)), m_progressBar, SLOT(setValue(int)));
    this->connect(m_webView, SIGNAL(loadStarted()), m_progressBar, SLOT(show()));
    this->connect(m_webView, SIGNAL(loadFinished(bool)), m_progressBar, SLOT(hide()));

    this->onOrientationChanged();
}

void DailymotionPrivateAuthDialog::checkUrl(const QUrl &url) {
    if (!url.toString().contains("login")) {
        m_jar->storeDailymotionCookies();
        this->accept();
    }
}
