#include "dailymotioncategoriesdialog.h"
#include "textlistdelegate.h"
#include "../base/dailymotioncategorymodel.h"
#include "listview.h"
#include "separatorlabel.h"
#include <QVBoxLayout>

DailymotionCategoriesDialog::DailymotionCategoriesDialog(QWidget *parent) :
    AbstractDialog(parent),
    m_model(new DailymotionCategoryModel(this)),
    m_view(new ListView(this))
{
    this->setWindowTitle(tr("Dailymotion categories"));
    m_view->setModel(m_model);
    m_view->setModel(m_model);
    m_view->setItemDelegate(new TextListDelegate(Qt::DisplayRole, Qt::AlignVCenter, m_view));
    m_view->setMinimumHeight(m_view->sizeHintForRow(0) * 5);

    QVBoxLayout *vbox = new QVBoxLayout(this);
    vbox->addWidget(m_view);

    this->connect(m_view, SIGNAL(clicked(QModelIndex)), this, SLOT(onCategoryChosen(QModelIndex)));
}

void DailymotionCategoriesDialog::onCategoryChosen(const QModelIndex &index) {
    emit categoryChosen(Services::Dailymotion, m_model->name(index.row()), m_model->value(index.row()).toString());
    this->accept();
}
