#ifndef YOUTUBEACCOUNTSLISTMODEL_H
#define YOUTUBEACCOUNTSLISTMODEL_H

#include <QSqlTableModel>

class Session;

class YouTubeAccountsListModel : public QSqlTableModel
{
    Q_OBJECT

    Q_PROPERTY(Session* session
               READ session
               WRITE setSession)
    Q_PROPERTY(int count
               READ rowCount
               NOTIFY countChanged)

public:
    enum Roles {
        DisplayNameRole = Qt::DisplayRole,
        UsernameRole,
        AccessTokenRole,
        RefreshTokenRole,
        CookiesRole,
        ActiveRole
    };

public:
    explicit YouTubeAccountsListModel(Session *session = 0, QObject *parent = 0);
    ~YouTubeAccountsListModel();
    inline Session* session() const { return m_session; }
    void setSession(Session *session);
    QVariant data(const QModelIndex &idx, int role) const;
    Q_INVOKABLE QVariant data(int row, const QByteArray &role) const;

public slots:
    void switchAccount(int row);
    void addAccount(const QString &displayName, const QString &token, const QString &refresh);
    void deleteAccount(int row);

private:
    void setActiveAccount(int row);

signals:
    void accountSelected(const QString &user, const QString &token, const QString &refresh);
    void accountAdded(const QString &user, const QString &token, const QString &refresh);
    void accountDeleted();
    void gotCookies(const QByteArray &cookieString);
    void info(const QString &message);
    void error(const QString &errorString);
    void countChanged(int count);

private:
    Session *m_session;
};

#endif // YOUTUBEACCOUNTSLISTMODEL_H
