#include "videolauncher.h"
#include <qplatformdefs.h>
#include <QUrl>
#ifndef Q_OS_SYMBIAN
#include <QProcess>
#endif
#ifdef Q_WS_MAEMO_5
#include <QDBusConnection>
#include <QDBusMessage>
#include <QDBusInterface>
#elif defined (MEEGO_EDITION_HARMATTAN)
#include <contentaction/contentaction.h>
#elif defined (Q_OS_SYMBIAN)
#include <QTemporaryFile>
#include <QDesktopServices>
#include <QTimer>
#include <QDir>
#endif

VideoLauncher::VideoLauncher(QObject *parent) :
    QObject(parent),
    m_mediaplayer("mediaplayer")
{
}

void VideoLauncher::setMediaPlayer(const QString &player) {
    m_mediaplayer = player.simplified().toLower();
}

void VideoLauncher::setCustomCommand(const QString &command) {
    m_command = command.simplified();
}

void VideoLauncher::launchVideo(const QUrl &url) {
    if (this->mediaPlayer() == "cutetube") {
        return;
    }
#ifdef Q_OS_LINUX
    if (this->mediaPlayer() == "other") {
        QStringList args = this->customCommand().split(' ', QString::SkipEmptyParts);
        QProcess *player = new QProcess();
        this->connect(player, SIGNAL(finished(int, QProcess::ExitStatus)), player, SLOT(deleteLater()));
        player->start(args.takeFirst(), args << url.toString());
    }
    else if (this->mediaPlayer() == "mplayer") {
        QStringList args;
        args << "-cache" << "2048" << "-fs" << url.toString();
        QProcess *player = new QProcess();
        this->connect(player, SIGNAL(finished(int, QProcess::ExitStatus)), player, SLOT(deleteLater()));
        player->start("/usr/bin/mplayer", args);
    }
#endif
#ifdef MEEGO_EDITION_HARMATTAN
    else if (this->mediaPlayer() == "mediaplayer") {
        ContentAction::Action::launcherAction("videosuiteinterface.desktop", QStringList(url.toString())).trigger();
    }
    else if (this->mediaPlayer() == "kmplayer") {
        ContentAction::Action::launcherAction("kmplayer.desktop", QStringList(url.toString())).trigger();
    }
#endif
    else {
#ifdef Q_WS_MAEMO_5
        QDBusConnection bus = QDBusConnection::sessionBus();
        QDBusInterface dbus_iface("com.nokia." + this->mediaPlayer(), "/com/nokia/" + this->mediaPlayer(), "com.nokia." + this->mediaPlayer(), bus);
        dbus_iface.call("mime_open", url.toString());
#elif defined (Q_OS_SYMBIAN)
        QTemporaryFile *temp = new QTemporaryFile(this);
        temp->setFileName(QDir::tempPath() + "/cutetube.ram");

        if ((temp->open()) && (temp->write(url.toString().toUtf8()) > 0)) {
            QDesktopServices::openUrl(QUrl::fromLocalFile(temp->fileName()));
        }

        temp->close();
        QTimer::singleShot(5000, temp, SLOT(deleteLater()));
#endif
    }
}
