#ifndef USERITEM_H
#define USERITEM_H

#include <QObject>
#include <QUrl>
#include <QDomElement>
#include <QVariantMap>

class UserItem : public QObject
{
    Q_OBJECT

    Q_PROPERTY(QString id
               READ id
               CONSTANT)
    Q_PROPERTY(QString username
               READ username
               CONSTANT)
    Q_PROPERTY(QString channelName
               READ channelName
               CONSTANT)
    Q_PROPERTY(QString description
               READ description
               CONSTANT)
    Q_PROPERTY(QUrl avatarUrl
               READ avatarUrl
               CONSTANT)
    Q_PROPERTY(QString location
               READ location
               CONSTANT)
    Q_PROPERTY(int videoCount
               READ videoCount
               NOTIFY videoCountChanged)
    Q_PROPERTY(int viewCount
               READ viewCount
               CONSTANT)
    Q_PROPERTY(int subscriberCount
               READ subscriberCount
               NOTIFY subscriberCountChanged)
    Q_PROPERTY(bool subscription
               READ subscription
               CONSTANT)
    Q_PROPERTY(bool subscribed
               READ subscribed
               NOTIFY subscribedChanged)
    Q_PROPERTY(QString subscriptionId
               READ subscriptionId
               NOTIFY subscriptionIdChanged)
    Q_PROPERTY(bool accountLinked
               READ accountLinked
               WRITE setAccountLinked
               NOTIFY accountLinkedChanged)

public:
    explicit UserItem(QObject *parent = 0);
    explicit UserItem(UserItem *user, QObject *parent = 0);
    ~UserItem() {}
    void loadDailymotionUser(const QVariantMap &user, bool subscribed = false);
    void loadYouTubeUser(const QDomNode &user, bool subscription = false, bool subscribed = false);
    void loadVimeoContact(const QDomElement &contact, bool subscribed = false);
    void loadVimeoProfile(const QDomElement &profile);
    inline QString id() const { return m_id; }
    inline void setId(const QString &id) { m_id = id; }
    inline QString username() const { return m_username; }
    inline void setUsername(const QString &user) { m_username = user; }
    inline QString channelName() const { return m_channelName; }
    inline void setChannelName(const QString &name) { m_channelName = name; }
    inline QString description() const { return m_description; }
    inline void setDescription(const QString &description) { m_description = description; }
    inline QUrl avatarUrl() const { return m_avatarUrl; }
    inline void setAvatarUrl(const QUrl &url) { m_avatarUrl = url; }
    inline QString location() const { return m_location; }
    inline void setLocation(const QString &location) { m_location = location; }
    inline int videoCount() const { return m_videoCount; }
    inline void setVideoCount(int count) { m_videoCount = count; emit videoCountChanged(count); }
    inline int viewCount() const { return m_viewCount; }
    inline void setViewCount(int count) { m_viewCount = count; }
    inline int subscriberCount() const { return m_subscriberCount; }
    inline void setSubscriberCount(int count) { m_subscriberCount = count; emit subscriberCountChanged(count); }
    inline QUrl websiteUrl() const { return m_websiteUrl; }
    inline void setWebsiteUrl(const QUrl &url) { m_websiteUrl = url; }
    inline bool subscription() const { return m_subscription; }
    inline void setSubscription(bool subscription) { m_subscription = subscription; }
    inline bool subscribed() const { return m_subscribed; }
    inline void setSubscribed(bool subscribed) { m_subscribed = subscribed; emit subscribedChanged(subscribed); }
    inline QString subscriptionId() const { return m_subscriptionId; }
    inline void setSubscriptionId(const QString &id) { m_subscriptionId = id; emit subscriptionIdChanged(id); }
    inline bool accountLinked() const { return m_accountLinked; }

public slots:
    inline void setAccountLinked(bool linked) { m_accountLinked = linked; emit accountLinkedChanged(linked); }
    void onSubscriptionChanged(const QString &userId, bool subscribed, const QString &subscriptionId = QString());

signals:
    void videoCountChanged(int count);
    void subscriberCountChanged(int count);
    void subscribedChanged(bool subscribed);
    void subscriptionIdChanged(const QString &id);
    void accountLinkedChanged(bool linked);

private:
    QString m_id;
    QString m_username;
    QString m_channelName;
    QString m_description;
    QUrl m_avatarUrl;
    QString m_location;
    int m_videoCount;
    int m_viewCount;
    int m_subscriberCount;
    QUrl m_websiteUrl;
    bool m_subscription;
    bool m_subscribed;
    QString m_subscriptionId;
    bool m_accountLinked;
};

#endif // USERITEM_H
