#ifndef TRANSFERITEM_H
#define TRANSFERITEM_H

#include "enums.h"
#include "videoitem.h"
#include <qplatformdefs.h>
#include <QObject>
#include <QUrl>
#include <QFile>
#include <QTime>
#include <QProcess>
#ifdef MEEGO_EDITION_HARMATTAN
#include <TransferUI/Transfer>
#endif

#ifdef MEEGO_EDITION_HARMATTAN
using namespace TransferUI;
#else
class Transfer;
#endif
class Session;
class UrlGrabber;
class QNetworkAccessManager;
class QNetworkReply;
class QTimer;

class TransferItem : public QObject
{
    Q_OBJECT

    Q_PROPERTY(QString id
               READ id
               CONSTANT)
    Q_PROPERTY(QString videoId
               READ videoId
               CONSTANT)
    Q_PROPERTY(QString title
               READ title
               CONSTANT)
    Q_PROPERTY(QUrl thumbnailUrl
               READ thumbnailUrl
               CONSTANT)
    Q_PROPERTY(Services::VideoService service
               READ service
               CONSTANT)
    Q_PROPERTY(QString fileName
               READ fileName
               WRITE setFileName
               NOTIFY fileNameChanged)
    Q_PROPERTY(Transfers::TransferStatus status
               READ status
               WRITE setStatus
               NOTIFY statusChanged)
    Q_PROPERTY(QString statusText
               READ statusText
               NOTIFY statusChanged)
    Q_PROPERTY(QString statusInfo
               READ statusInfo
               NOTIFY statusInfoChanged)
    Q_PROPERTY(Transfers::TransferPriority priority
               READ priority
               WRITE setPriority
               NOTIFY priorityChanged)
    Q_PROPERTY(QString priorityText
               READ priorityText
               NOTIFY priorityChanged)
    Q_PROPERTY(int progress
               READ progress
               NOTIFY progressChanged)
    Q_PROPERTY(double speed
               READ speed
               NOTIFY speedChanged)
    Q_PROPERTY(qint64 size
               READ size
               NOTIFY sizeChanged)
    Q_PROPERTY(bool convertibleToAudio
               READ convertibleToAudio
               NOTIFY convertibleToAudioChanged)
    Q_PROPERTY(bool saveAsAudio
               READ saveAsAudio
               WRITE setSaveAsAudio
               NOTIFY saveAsAudioChanged)
    Q_PROPERTY(Transfers::TransferType transferType
               READ transferType
               CONSTANT)

public:
    explicit TransferItem(QObject *parent = 0);
    explicit TransferItem(const QString &id, VideoItem* video, Transfers::TransferStatus status, bool saveAsAudio, QObject *parent = 0);
    explicit TransferItem(const QVariantMap &metadata, QObject *parent = 0);
    ~TransferItem();
    inline Transfer* harmattanTransfer() const { return m_transfer; }
    void setHarmattanTransfer(Transfer *transfer);
    inline Session* session() const { return m_session; }
    inline void setSession(Session *session) { m_session = session; }
    inline QNetworkAccessManager* networkAccessManager() const { return m_nam; }
    inline void setNetworkAccessManager(QNetworkAccessManager *manager) { m_nam = manager; }
    inline QString id() const { return m_id; }
    inline void setId(const QString &id) { m_id = id; }
    inline QString videoId() const { return m_videoId; }
    inline void setVideoId(const QString &id) { m_videoId = id; }
    inline QString title() const { return m_title; }
    inline void setTitle(const QString &title) { m_title = title; }
    inline QUrl thumbnailUrl() const { return m_thumbnailUrl; }
    inline void setThumbnailUrl(const QUrl &url) { m_thumbnailUrl = url; }
    inline Services::VideoService service() const { return m_service; }
    inline void setService(Services::VideoService service) { m_service = service; }
    inline QString fileName() const { return m_filename; }
    void setFileName(const QString &name);
    inline QString tempFileName() const { return m_tempFileName; }
    inline void setTempFileName(const QString &name) { m_tempFileName = name; }
    inline QString downloadPath() const { return m_downloadPath; }
    inline void setDownloadPath(const QString &path) { m_downloadPath = path; }
    inline Transfers::TransferStatus status() const { return m_status; }
    QString statusText() const;
    inline QString statusInfo() const { return m_statusInfo; }
    inline Transfers::TransferPriority priority() const { return m_priority; }
    inline int progress() const { return m_progress; }
    inline void setProgress(int progress) { m_progress = progress; }
    inline double speed() const { return m_speed; }
    inline void setSpeed(double speed) { m_speed = speed; }
    void setStatus(Transfers::TransferStatus status);
    void setStatusInfo(const QString &info);
    QString priorityText() const;
    inline qint64 size() const { return m_size; }
    void setSize(qint64 size);
    inline uint row() const { return m_row; }
    void setRow(uint row);
    bool convertibleToAudio() const;
    inline bool saveAsAudio() const { return m_saveAsAudio; }
    inline QVariantMap uploadMetadata() const { return m_uploadMetadata; }
    inline void setUploadMetadata(const QVariantMap &metadata) { m_uploadMetadata = metadata; }
    inline Qualities::VideoQuality quality() const { return m_quality; }
    inline void setQuality(Qualities::VideoQuality quality) { m_quality = quality; }
    inline Transfers::TransferType transferType() const { return m_transferType; }
    inline void setTransferType(Transfers::TransferType type) { m_transferType = type; }

public slots:
    void startTransfer(bool resetRetries = true);
    void setPriority(Transfers::TransferPriority priority);
    void setSaveAsAudio(bool saveAsAudio);

private:
    void startUpload();
    void pauseTransfer();
    void cancelTransfer();
    void downloadThumbnail();
    void convertVideoToAudio();
    void moveDownloadedFiles();

private slots:
    void performDownload(const QUrl &url);
    void setUploadUrl();
    void performUpload(const QUrl &url);
    void onDownloadMetadataChanged();
    void onDownloadReadyRead();
    void onProgressChanged(qint64 received, qint64 total);
    void updateProgress();
    void onDownloadFinished();
    void onUploadFinished();
    void onThumbnailDownloadFinished();
    void onConvertToAudioFinished(int exitCode, QProcess::ExitStatus exitStatus);
    void onUrlError(const QString &errorString);
    void onHarmattanTransferPauseRequest();
    void onHarmattanTransferCancelRequest();

signals:
    void progressChanged(int progress);
    void speedChanged(double speed);
    void statusChanged(Transfers::TransferStatus status);
    void statusInfoChanged(const QString &info);
    void priorityChanged(Transfers::TransferPriority priority);
    void sizeChanged(qint64 size);
    void fileNameChanged(const QString &fileName);
    void rowChanged(uint row);
    void convertibleToAudioChanged(bool convertible);
    void saveAsAudioChanged(bool saveAsAudio);

private:
    Transfer *m_transfer;
    Session *m_session;
    UrlGrabber *m_grabber;
    QNetworkAccessManager *m_nam;
    QNetworkReply *m_reply;
    QProcess *m_process;
    QTimer *m_progressTimer;
    QFile m_file;
    QString m_id;
    QString m_videoId;
    QString m_title;
    QUrl m_thumbnailUrl;
    Services::VideoService m_service;
    QString m_category;
    QString m_filename;
    QString m_tempFileName;
    QString m_downloadPath;
    Transfers::TransferStatus m_status;
    QString m_statusText;
    QString m_statusInfo;
    Transfers::TransferPriority m_priority;
    int m_progress;
    double m_speed;
    qint64 m_size;
    QString m_priorityText;
    int m_retries;
    QTime m_transferTime;
    uint m_row;
    mutable bool m_convertible;
    mutable bool m_checkedIfConvertible;
    bool m_saveAsAudio;
    QVariantMap m_uploadMetadata;
    Qualities::VideoQuality m_quality;
    Transfers::TransferType m_transferType;
};

#endif // TRANSFERITEM_H
