#ifndef PLAYBACKLISTMODEL_H
#define PLAYBACKLISTMODEL_H

#include "abstractvideolistmodel.h"

class Session;

class PlaybackListModel : public AbstractVideoListModel
{
    Q_OBJECT

    Q_PROPERTY(Session* session
               READ session
               WRITE setSession)
    Q_PROPERTY(int count
               READ rowCount
               NOTIFY countChanged)
    Q_PROPERTY(bool itemsSelected
               READ itemsSelected
               NOTIFY itemsSelectedChanged)

public:
    explicit PlaybackListModel(Session *session = 0, QObject *parent = 0);
    Session *session() const { return m_session; }
    inline void setSession(Session *session) { m_session = session; }
    void insertVideo(int row, QSharedPointer<VideoItem> video);
    Q_INVOKABLE void insertVideoFromQML(int row, VideoItem *video);
    void addVideo(QSharedPointer<VideoItem> video);
    Q_INVOKABLE void addVideoFromQML(VideoItem *video);
    void addVideos(QList< QSharedPointer<VideoItem> > videos);
    Q_INVOKABLE void addVideosFromQML(QList<VideoItem*> videos);
    Q_INVOKABLE VideoItem* getFromQML(int row) const;

public slots:
    void removeVideo(int row);
    void removeSelectedVideos();
    void downloadSelectedVideos(bool saveAsAudio = false);
    inline void toggleSelected(int row) { AbstractVideoListModel::toggleSelected(row); emit itemsSelectedChanged(this->itemsSelected()); }
    inline void selectAll() { AbstractVideoListModel::selectAll(); emit itemsSelectedChanged(true); }
    inline void selectNone() { AbstractVideoListModel::selectNone(); emit itemsSelectedChanged(false); }

signals:
    void alert(const QString &message);
    void countChanged(int count);
    void itemsSelectedChanged(bool selected);

private:
    Session *m_session;
};

#endif // PLAYBACKLISTMODEL_H
