#include "dailymotionuserplaylistlistmodel.h"
#include "session.h"
#ifdef QML_USER_INTERFACE
#include <QDeclarativeEngine>
#endif

DailymotionUserPlaylistListModel::DailymotionUserPlaylistListModel(Session *session, QObject *parent) :
    QAbstractListModel(parent),
    m_session(session)
{
    QHash<int, QByteArray> roles;
    roles[IdRole] = "id";
    roles[PlaylistIdRole] = "playlistId";
    roles[TitleRole] = "title";
    roles[ArtistRole] = "artist";
    roles[DateRole] = "date";
    roles[VideoCountRole] = "videoCount";
    roles[DescriptionRole] = "description";
    this->setRoleNames(roles);

    if (this->session()) {
        if (!this->session()->dailymotion()->playlistsLoaded()) {
            this->session()->dailymotion()->getPlaylists();
        }

        this->connect(this->session()->dailymotion(), SIGNAL(playlistAddedToCache(int)), this, SLOT(onPlaylistAdded(int)));
        this->connect(this->session()->dailymotion(), SIGNAL(playlistRemovedFromCache(int)), this, SLOT(onPlaylistRemoved(int)));
        this->connect(this->session()->dailymotion(), SIGNAL(playlistUpdated(int)), this, SLOT(onPlaylistUpdated(int)));
    }
}

void DailymotionUserPlaylistListModel::setSession(Session *session) {
    m_session = session;

    if (this->session()) {
        if (!this->session()->dailymotion()->playlistsLoaded()) {
            this->session()->dailymotion()->getPlaylists();
        }

        this->connect(this->session()->dailymotion(), SIGNAL(playlistAddedToCache(int)), this, SLOT(onPlaylistAdded(int)));
        this->connect(this->session()->dailymotion(), SIGNAL(playlistRemovedFromCache(int)), this, SLOT(onPlaylistRemoved(int)));
        this->connect(this->session()->dailymotion(), SIGNAL(playlistUpdated(int)), this, SLOT(onPlaylistUpdated(int)));
    }
}

void DailymotionUserPlaylistListModel::onPlaylistAdded(int row) {
    this->beginInsertRows(QModelIndex(), row, row);
    this->endInsertRows();
    emit countChanged(this->rowCount());
}

void DailymotionUserPlaylistListModel::onPlaylistRemoved(int row) {
    this->beginRemoveRows(QModelIndex(), row, row);
    this->endRemoveRows();
    emit countChanged(this->rowCount());
}

void DailymotionUserPlaylistListModel::onPlaylistUpdated(int row) {
    emit dataChanged(this->index(row), this->index(row));
}

int DailymotionUserPlaylistListModel::rowCount(const QModelIndex &parent) const {
    Q_UNUSED(parent)

    return !this->session() ? 0 : this->session()->dailymotion()->playlists()->size();
}

QVariant DailymotionUserPlaylistListModel::data(const QModelIndex &index, int role) const {
    switch (role) {
    case IdRole:
        return this->session()->dailymotion()->playlists()->at(index.row()).data()->id();
    case PlaylistIdRole:
        return this->session()->dailymotion()->playlists()->at(index.row()).data()->playlistId();
    case TitleRole:
        return this->session()->dailymotion()->playlists()->at(index.row()).data()->title();
    case ArtistRole:
        return this->session()->dailymotion()->playlists()->at(index.row()).data()->artist();
    case DateRole:
        return this->session()->dailymotion()->playlists()->at(index.row()).data()->date();
    case VideoCountRole:
        return this->session()->dailymotion()->playlists()->at(index.row()).data()->videoCount();
    case DescriptionRole:
        return this->session()->dailymotion()->playlists()->at(index.row()).data()->description();
    default:
        return QVariant();
    }
}

QVariant DailymotionUserPlaylistListModel::data(int row, const QByteArray &role) const {
    return this->data(this->index(row), this->roleNames().key(role));
}

QSharedPointer<PlaylistItem> DailymotionUserPlaylistListModel::get(int row) const {
    return QSharedPointer<PlaylistItem>(this->session()->dailymotion()->playlists()->at(row));
}

PlaylistItem* DailymotionUserPlaylistListModel::getFromQML(int row) const {
#ifdef QML_USER_INTERFACE
    PlaylistItem* playlist = new PlaylistItem(this->session()->dailymotion()->playlists()->at(row).data());
    QDeclarativeEngine::setObjectOwnership(playlist, QDeclarativeEngine::JavaScriptOwnership);

    return playlist;
#else
    Q_UNUSED(row)
#endif
    return 0;
}
