#ifndef DAILYMOTIONUSERGROUPLISTMODEL_H
#define DAILYMOTIONUSERGROUPLISTMODEL_H

#include "groupitem.h"
#include <QAbstractListModel>
#include <QSharedPointer>

class Session;

class DailymotionUserGroupListModel : public QAbstractListModel
{
    Q_OBJECT

    Q_PROPERTY(Session* session
               READ session
               WRITE setSession)
    Q_PROPERTY(int count
               READ rowCount
               NOTIFY countChanged)

public:
    enum Roles {
        IdRole = Qt::UserRole + 1,
        TitleRole,
        ArtistRole,
        DateRole,
        DescriptionRole
    };

public:
    explicit DailymotionUserGroupListModel(Session *session = 0, QObject *parent = 0);
    ~DailymotionUserGroupListModel() {}
    inline Session* session() const { return m_session; }
    void setSession(Session *session);
    int rowCount(const QModelIndex &parent = QModelIndex()) const;
    QVariant data(const QModelIndex &index, int role = Qt::DisplayRole) const;
    Q_INVOKABLE QVariant data(int row, const QByteArray &role) const;
    QSharedPointer<GroupItem> get(int row) const;
    Q_INVOKABLE GroupItem* getFromQML(int row) const;

private slots:
    void onGroupAdded(int row);
    void onGroupRemoved(int row);

signals:
    void countChanged(int count);

private:
    Session *m_session;
};

#endif // DAILYMOTIONUSERGROUPLISTMODEL_H
