#ifndef EVENTS_H
#define EVENTS_H

#include "event.h"
#include <QDateTime>

class YouTube;
class Dailymotion;
class Vimeo;
class Database;
class QNetworkAccessManager;

class Events : public QObject
{
    Q_OBJECT

public:
    Events(QObject *parent = 0);
    ~Events() {}

public slots:
    bool enableSync();
    bool disableSync();
    void startSync();

private slots:
    void abortSync();
    void syncSuccess();
    void syncFailed();
    void getEvents();
    void getYouTubeEvents();
    void processYouTubeEvents();
    void getDailymotionEvents();
    void processDailymotionEvents();
    void getVimeoEvents();
    void processVimeoEvents();
    void onThumbnailDownloaded();

private:
    void init();
    void addEvents();
    QString base64SerializedVariant(const QVariant &value) const;
    void downloadThumbnails();

private:
    QNetworkAccessManager *m_nam;
    Database *m_database;
    YouTube *m_youtube;
    Dailymotion *m_dailymotion;
    Vimeo *m_vimeo;
    QList<Event> m_events;
    int m_index;
    bool m_initialized;
    QDateTime m_youtubeLatest;
    QDateTime m_dailymotionLatest;
    QDateTime m_vimeoLatest;
};

#endif  //  EVENTS_H
