#ifndef VIMEOVIDEOLISTWINDOW_H
#define VIMEOVIDEOLISTWINDOW_H

#include "stackedwindow.h"
#include "../base/groupitem.h"
#include "../base/videoitem.h"

class VimeoVideoListModel;
class ListView;
class QAction;
class QLabel;
class QModelIndex;

class VimeoVideoListWindow : public StackedWindow
{
    Q_OBJECT
public:
    explicit VimeoVideoListWindow(Session *session, QWidget *parent);
    void setVideoFeed(const QString &feed);
    void getGroupVideos(QSharedPointer<GroupItem> group);
    void search(const QString &query, Queries::QueryOrder order);

protected:
    void showEvent(QShowEvent *event);

private:
    void setLandscapeLayout();
    void setPortraitLayout();

private slots:
    void setMenuActions();
    void onLoadingChanged(bool loading);
    void onCountChanged(int count);
    void toggleGroupMembership();
    void deleteVideosFromUploads();
    void addVideosToLikes();
    void deleteVideosFromLikes();
    void addVideosToAlbum();
    void addVideosToWatchLaterAlbum();
    void deleteVideosFromWatchLaterAlbum();
    void addVideoDownloads();
    void addAudioDownloads();
    void queueVideos();
    void showContextMenu(const QPoint &pos);
    void deleteVideoFromUploads();
    void addVideoToLikes();
    void deleteVideoFromLikes();
    void showAlbumDialog();
    void addVideoToAlbum(const QString &id);
    void addVideoToNewAlbum(const QVariantMap &album);
    void addVideoToWatchLaterAlbum();
    void deleteVideoFromWatchLaterAlbum();
    void addVideoDownload();
    void addAudioDownload();
    void queueVideo();
    void onItemClicked(const QModelIndex &index);
    void showVideoInfo(QSharedPointer<VideoItem> video);
    void playVideo(const QModelIndex &index);

private:
    ListView *m_listView;
    VimeoVideoListModel *m_model;
    QSharedPointer<GroupItem> m_group;
    QAction *m_groupAction;
    QAction *m_deleteFromUploadsAction;
    QAction *m_deleteFromWatchLaterAction;
    QAction *m_addToLikesAction;
    QAction *m_deleteFromLikesAction;
    QAction *m_addToAlbumAction;
    QAction *m_addToWatchLaterAction;
    QAction *m_addToQueueAction;
    QAction *m_videoDownloadAction;
    QAction *m_audioDownloadAction;
    QMenu *m_contextMenu;
    QAction *m_deleteFromUploadsContextAction;
    QAction *m_deleteFromWatchLaterContextAction;
    QAction *m_addToLikesContextAction;
    QAction *m_deleteFromLikesContextAction;
    QAction *m_addToAlbumContextAction;
    QAction *m_addToWatchLaterContextAction;
    QAction *m_addToQueueContextAction;
    QAction *m_videoDownloadContextAction;
    QAction *m_audioDownloadContextAction;
    QLabel *m_noResultsLabel;
};

#endif // VIMEOVIDEOLISTWINDOW_H
