#include "vimeogrouplisttab.h"
#include "vimeogrouplistdelegate.h"
#include "vimeovideolistwindow.h"
#include "listview.h"
#include "../base/session.h"
#include "../base/vimeogrouplistmodel.h"
#include <QLabel>
#include <QGridLayout>

VimeoGroupListTab::VimeoGroupListTab(Session *session, QWidget *parent) :
    AbstractTab(parent),
    m_session(session),
    m_listView(new ListView(this)),
    m_model(new VimeoGroupListModel(m_session, this)),
    m_noResultsLabel(new QLabel(QString("<p style='color:#4d4d4d;font-size:40px;'><center><b>%1</b></center></p>").arg(tr("No groups found")), this)),
    m_grid(new QGridLayout(this))
{
    m_grid->setContentsMargins(0, 0, 0, 0);
    m_grid->addWidget(m_listView, 0, 0);
    m_listView->setModel(m_model);
    m_listView->setItemDelegate(new VimeoGroupListDelegate(m_listView));
    m_noResultsLabel->hide();

    this->connect(m_model, SIGNAL(loadingChanged(bool)), this, SLOT(onLoadingChanged(bool)));
    this->connect(m_model, SIGNAL(countChanged(int)), this, SLOT(onCountChanged(int)));
    this->connect(m_listView, SIGNAL(clicked(QModelIndex)), this, SLOT(onItemClicked(QModelIndex)));
    this->connect(m_listView, SIGNAL(atEnd()), m_model, SLOT(getMoreGroups()));

    this->onOrientationChanged();
}

void VimeoGroupListTab::setGroupFeed(const QString &feed) {
    m_model->getGroups(feed);
}

void VimeoGroupListTab::setLandscapeLayout() {
    m_noResultsLabel->setFixedSize(800, 400);
}

void VimeoGroupListTab::setPortraitLayout() {
    m_noResultsLabel->setFixedSize(480, 700);
}

void VimeoGroupListTab::onLoadingChanged(bool loading) {
    m_session->toggleBusy(loading);
    m_noResultsLabel->setVisible((!loading) && (m_model->rowCount() == 0));
}

void VimeoGroupListTab::onCountChanged(int count) {
    m_noResultsLabel->setVisible((count == 0) && (!m_model->loading()));
}

void VimeoGroupListTab::onItemClicked(const QModelIndex &index) {
    if (index.isValid()) {
        this->showGroup(m_model->get(index.row()));
    }
}

void VimeoGroupListTab::showGroup(QSharedPointer<GroupItem> group) {
    VimeoVideoListWindow *window = new VimeoVideoListWindow(m_session, m_session->currentWindow());
    window->setWindowTitle(group.data()->title());
    window->getGroupVideos(group);
    window->show();
}
