#include "socialvideoselectionwindow.h"
#include "videoselectiondelegate.h"
#include "../base/socialvideolistmodel.h"
#include "../base/session.h"
#include "listview.h"
#include <QMaemo5EditBar>
#include <QPushButton>
#include <QVBoxLayout>

SocialVideoSelectionWindow::SocialVideoSelectionWindow(Session *session, SocialVideoListModel *model, const QString &text, const char* slot, QWidget *parent) :
    QWidget(parent),
    m_session(session),
    m_model(model),
    m_listView(new ListView(this)),
    m_editBar(new QMaemo5EditBar(tr("Select videos"), this)),
    m_acceptButton(new QPushButton(text, this)),
    m_vbox(new QVBoxLayout(this))
{
    this->setWindowFlags(Qt::Window);
    this->setWindowState(Qt::WindowFullScreen);
    this->setAttribute(Qt::WA_Maemo5StackedWindow, true);
    this->setAttribute(Qt::WA_DeleteOnClose, true);

    m_listView->setModel(m_model);
    m_listView->setItemDelegate(new VideoSelectionDelegate(m_listView));

    m_editBar->addButton(m_acceptButton);
    m_vbox->setContentsMargins(0, 0, 0, 0);
    m_vbox->setSpacing(0);
    m_vbox->addWidget(m_editBar);
    m_vbox->addWidget(m_listView);

    this->connect(m_listView, SIGNAL(clicked(QModelIndex)), this, SLOT(onItemClicked(QModelIndex)));
    this->connect(m_acceptButton, SIGNAL(clicked()), this, SLOT(onButtonClicked()));
    this->connect(this, SIGNAL(accepted()), this, slot);
}

SocialVideoSelectionWindow::~SocialVideoSelectionWindow() {
    m_model->selectNone();
}

void SocialVideoSelectionWindow::positionAtIndex(const QModelIndex &index) {
    m_listView->scrollTo(index, QListView::PositionAtTop);
}

void SocialVideoSelectionWindow::onItemClicked(const QModelIndex &index) {
    m_model->toggleSelected(index.row());
}

void SocialVideoSelectionWindow::onButtonClicked() {
    if (m_model->itemsSelected()) {
        emit accepted();
    }
}

void SocialVideoSelectionWindow::addVideoDownloads() {
    m_session->addDownloadTransfers(m_model->selectedItems());
    this->close();
}

void SocialVideoSelectionWindow::addAudioDownloads() {
    m_session->addDownloadTransfers(m_model->selectedItems(), true);
    this->close();
}

void SocialVideoSelectionWindow::queueVideos() {
    m_session->playbackQueue()->addVideos(m_model->selectedItems());
    this->close();
}
