#include "sharetotwitterdialog.h"
#include "../base/session.h"
#include <QTextEdit>
#include <QPushButton>
#include <QDialogButtonBox>
#include <QGridLayout>
#include <QScrollArea>
#include <QLabel>
#include <QApplication>
#include <QStyle>

ShareToTwitterDialog::ShareToTwitterDialog(Session *session, QSharedPointer<VideoItem> video, QWidget *parent) :
    AbstractDialog(parent),
    m_session(session),
    m_video(video),
    m_messageEdit(new QTextEdit(m_video.data()->url().toString())),
    m_charCountLabel(new QLabel(QString::number(140 - m_messageEdit->toPlainText().size()), this)),
    m_buttonBox(new QDialogButtonBox(Qt::Vertical, this)),
    m_doneButton(m_buttonBox->addButton(tr("Done"), QDialogButtonBox::AcceptRole)),
    m_scrollArea(new QScrollArea(this)),
    m_grid(new QGridLayout(this)),
    m_textColor(QApplication::style()->standardPalette().color(QPalette::Text).name())
{
    this->setWindowTitle(tr("Share to twitter"));

    QLabel *messageLabel = new QLabel(tr("Message"), this);
    QWidget *scrollWidget = new QWidget(m_scrollArea);
    QGridLayout *grid = new QGridLayout(scrollWidget);

    grid->addWidget(messageLabel, 0, 0);
    grid->addWidget(m_charCountLabel, 0, 1, Qt::AlignRight);
    grid->addWidget(m_messageEdit, 1, 0, 1, 2);

    m_scrollArea->setWidgetResizable(true);
    m_scrollArea->setWidget(scrollWidget);
    m_scrollArea->setHorizontalScrollBarPolicy(Qt::ScrollBarAlwaysOff);

    this->connect(m_messageEdit, SIGNAL(textChanged()), this, SLOT(onMessageTextChanged()));

    this->onOrientationChanged();
}

void ShareToTwitterDialog::setLandscapeLayout() {
    this->setFixedHeight(340);
    m_buttonBox->setSizePolicy(QSizePolicy::Fixed, QSizePolicy::Fixed);

    if (m_grid->isEmpty()) {
        m_grid->addWidget(m_scrollArea, 0, 0);
        m_grid->addWidget(m_buttonBox, 0, 1, Qt::AlignBottom);
    }
    else {
        m_grid->removeWidget(m_buttonBox);
        m_grid->addWidget(m_buttonBox, 0, 1, Qt::AlignBottom);
    }
}

void ShareToTwitterDialog::setPortraitLayout() {
    this->setFixedHeight(600);
    m_buttonBox->setSizePolicy(QSizePolicy::Expanding, QSizePolicy::Fixed);

    if (m_grid->isEmpty()) {
        m_grid->addWidget(m_scrollArea, 0, 0);
        m_grid->addWidget(m_buttonBox, 1, 0, Qt::AlignBottom);
    }
    else {
        m_grid->removeWidget(m_buttonBox);
        m_grid->addWidget(m_buttonBox, 1, 0, Qt::AlignBottom);
    }
}

void ShareToTwitterDialog::onMessageTextChanged() {
    int remainingChars = 140 - m_messageEdit->toPlainText().size();
    bool charCountTooHigh = remainingChars < 0;

    m_charCountLabel->setText(QString("<p style='color:%1'>%2</p>").arg(charCountTooHigh
                                                                        ? QString("red")
                                                                        : m_textColor).arg(QString::number(remainingChars)));
    m_doneButton->setEnabled(!charCountTooHigh);
}

void ShareToTwitterDialog::shareVideo() {
    QVariantMap share;
    share.insert("body", m_messageEdit->toPlainText());

    m_session->sharing()->postToTwitter(share);
    this->accept();
}
